/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.CocoaBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeFloweringRecipeCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation ID = new ResourceLocation("productivebees", "bee_flowering");
    private final IDrawable icon;
    private final IDrawable background;

    public BeeFloweringRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/bee_flowering_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 70, 82);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Items.field_221620_aV));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.productivebees.bee_flowering", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ingredients.setInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT, Collections.singletonList(recipe.getBee()));
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        try {
            List<Block> blockList = new ArrayList();
            if (recipe.blockTag != null) {
                blockList = recipe.blockTag.func_230236_b_();
            } else if (recipe.block != null) {
                blockList.add(recipe.block);
            }
            for (Block block : blockList) {
                ItemStack item = new ItemStack((IItemProvider)block.func_199767_j());
                if (!item.func_77973_b().equals(Items.field_190931_a)) {
                    stacks.add(item);
                    continue;
                }
                if (!(block instanceof CocoaBlock)) continue;
                stacks.add(new ItemStack((IItemProvider)Items.field_196130_bo));
            }
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.warn("Failed to find flowering requirements for " + recipe.getBee());
        }
        ArrayList<ArrayList<ItemStack>> items = new ArrayList<ArrayList<ItemStack>>();
        items.add(stacks);
        ingredients.setInputLists(VanillaTypes.ITEM, items);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, @Nonnull Recipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup ingredientStacks = iRecipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        ingredientStacks.init(0, true, 29, 12);
        ingredientStacks.set(0, (List)ingredients.getInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT).get(0));
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(1, true, 26, 51);
        itemStacks.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
    }

    public static List<Recipe> getFlowersRecipes(Map<String, BeeIngredient> beeList) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        HashMap<String, Object> flowering = new HashMap<String, Object>();
        flowering.put("productivebees:blue_banded_bee", ModTags.RIVER_FLOWERS);
        flowering.put("productivebees:green_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:nomad_bee", ModTags.ARID_FLOWERS);
        flowering.put("productivebees:reed_bee", ModTags.SWAMP_FLOWERS);
        flowering.put("productivebees:resin_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:sweaty_bee", ModTags.SNOW_FLOWERS);
        flowering.put("productivebees:yellow_black_carpenter_bee", ModTags.FOREST_FLOWERS);
        flowering.put("productivebees:lumber_bee", BlockTags.field_200031_h);
        flowering.put("productivebees:quarry_bee", ModTags.QUARRY);
        ITag.INamedTag defaultBlockTag = BlockTags.field_226149_I_;
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            if (entry.getValue().isConfigurable()) {
                CompoundNBT nbt = BeeReloadListener.INSTANCE.getData(entry.getValue().getBeeType().toString());
                if (nbt.func_74764_b("flowerTag")) {
                    ITag<Block> flowerTag = ModTags.getTag(new ResourceLocation(nbt.func_74779_i("flowerTag")));
                    recipes.add(new Recipe(flowerTag, entry.getValue()));
                    continue;
                }
                if (nbt.func_74764_b("flowerBlock")) {
                    Block flowerBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i("flowerBlock")));
                    recipes.add(new Recipe(flowerBlock, entry.getValue()));
                    continue;
                }
                recipes.add(new Recipe((ITag<Block>)defaultBlockTag, entry.getValue()));
                continue;
            }
            if (flowering.containsKey(entry.getValue().getBeeType().toString())) {
                ITag blockTag = (ITag)flowering.get(entry.getValue().getBeeType().toString());
                recipes.add(new Recipe((ITag<Block>)blockTag, entry.getValue()));
                continue;
            }
            recipes.add(new Recipe((ITag<Block>)defaultBlockTag, entry.getValue()));
        }
        return recipes;
    }

    public static class Recipe {
        private final BeeIngredient bee;
        private final ITag<Block> blockTag;
        private final Block block;

        public Recipe(ITag<Block> blockTag, BeeIngredient bee) {
            this.blockTag = blockTag;
            this.block = null;
            this.bee = bee;
        }

        public Recipe(Block block, BeeIngredient bee) {
            this.blockTag = null;
            this.block = block;
            this.bee = bee;
        }

        public BeeIngredient getBee() {
            return this.bee;
        }
    }
}

