/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.integrations.jei.ProductiveBeesJeiPlugin;
import cy.jdkdigital.productivebees.recipe.BlockConversionRecipe;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class BlockConversionRecipeCategory
implements IRecipeCategory<BlockConversionRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public BlockConversionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("productivebees", "textures/gui/jei/block_conversion.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 90, 52);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Items.field_221585_m));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return ProductiveBeesJeiPlugin.CATEGORY_BLOCK_CONVERSION_UID;
    }

    @Nonnull
    public Class<? extends BlockConversionRecipe> getRecipeClass() {
        return BlockConversionRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.productivebees.block_conversion", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(BlockConversionRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(ProductiveBeesJeiPlugin.BEE_INGREDIENT, Collections.singletonList(recipe.bee.get()));
        if (recipe.stateFrom.func_204520_s().func_206886_c().equals(Fluids.field_204541_a)) {
            ingredients.setInputs(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((IItemProvider)recipe.stateFrom.func_177230_c().func_199767_j())));
        } else {
            ingredients.setInputs(VanillaTypes.FLUID, Collections.singletonList(new FluidStack(recipe.stateFrom.func_204520_s().func_206886_c(), 1000)));
        }
        if (recipe.stateTo.func_204520_s().func_206886_c().equals(Fluids.field_204541_a)) {
            ingredients.setOutputs(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((IItemProvider)recipe.stateTo.func_177230_c().func_199767_j())));
        } else {
            ingredients.setOutputs(VanillaTypes.FLUID, Collections.singletonList(new FluidStack(recipe.stateTo.func_204520_s().func_206886_c(), 1000)));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, BlockConversionRecipe recipe, IIngredients ingredients) {
        IGuiIngredientGroup beeIngredients = recipeLayout.getIngredientsGroup(ProductiveBeesJeiPlugin.BEE_INGREDIENT);
        beeIngredients.init(0, true, 38, 5);
        beeIngredients.set(ingredients);
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        if (recipe.stateFrom.func_204520_s().func_206886_c().equals(Fluids.field_204541_a)) {
            itemStacks.init(1, true, 5, 25);
        } else {
            fluidStacks.init(1, true, 5, 26);
        }
        if (recipe.stateTo.func_204520_s().func_206886_c().equals(Fluids.field_204541_a)) {
            itemStacks.init(2, false, 65, 25);
        } else {
            fluidStacks.init(2, false, 65, 26);
        }
        itemStacks.set(ingredients);
        fluidStacks.set(ingredients);
    }
}

