/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeIngredient {
    private static Map<BeeIngredient, Entity> cache = new HashMap<BeeIngredient, Entity>();
    private EntityType<? extends Entity> bee;
    private ResourceLocation beeType;
    private boolean configurable = false;

    public BeeIngredient(EntityType<? extends Entity> bee) {
        this.bee = bee;
    }

    public BeeIngredient(EntityType<? extends Entity> bee, ResourceLocation beeType) {
        this(bee);
        this.beeType = beeType;
    }

    public BeeIngredient(EntityType<? extends Entity> bee, ResourceLocation beeType, boolean isConfigurable) {
        this(bee);
        this.beeType = beeType;
        this.configurable = isConfigurable;
    }

    public EntityType<? extends Entity> getBeeEntity() {
        return this.bee;
    }

    public BeeEntity getCachedEntity(World world) {
        Entity cachedEntity;
        if (!cache.containsKey(this)) {
            Entity newBee = this.getBeeEntity().func_200721_a(world);
            if (newBee instanceof ConfigurableBeeEntity) {
                ((ConfigurableBeeEntity)newBee).setBeeType(this.getBeeType().toString());
                ((ConfigurableBeeEntity)newBee).setAttributes();
            }
            cache.put(this, newBee);
        }
        if ((cachedEntity = cache.get(this)) instanceof BeeEntity) {
            return (BeeEntity)cachedEntity;
        }
        return null;
    }

    public ResourceLocation getBeeType() {
        return this.beeType != null ? this.beeType : this.bee.getRegistryName();
    }

    public static BeeIngredient fromNetwork(PacketBuffer buffer) {
        String beeName = buffer.func_218666_n();
        return new BeeIngredient((EntityType<? extends Entity>)((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(beeName))), buffer.func_192575_l(), buffer.readBoolean());
    }

    public final void toNetwork(PacketBuffer buffer) {
        buffer.func_180714_a("" + this.bee.getRegistryName());
        buffer.func_192572_a(this.getBeeType());
        buffer.writeBoolean(this.configurable);
    }

    public String toString() {
        return "BeeIngredient{bee=" + this.bee + ", beeType=" + this.beeType + '}';
    }

    public boolean isConfigurable() {
        return this.configurable;
    }
}

