/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeIngredientFactory {
    private static Map<String, BeeIngredient> ingredientList = new HashMap<String, BeeIngredient>();
    private static int configurableBeeIngredientCount = 0;

    public static String getIngredientKey(BeeEntity bee) {
        String type = bee.func_70022_Q();
        if (bee instanceof ProductiveBeeEntity) {
            type = ((ProductiveBeeEntity)bee).getBeeType();
        }
        return type;
    }

    public static Map<String, BeeIngredient> getOrCreateList(boolean removeDeprecated) {
        HashMap<String, BeeIngredient> list = new HashMap();
        if (removeDeprecated) {
            for (Map.Entry<String, BeeIngredient> entry : BeeIngredientFactory.getOrCreateList().entrySet()) {
                String beeId = entry.getKey().replace("productivebees:", "");
                if (beeId.equals("configurable_bee")) continue;
                list.put(entry.getKey(), entry.getValue());
            }
        } else {
            list = BeeIngredientFactory.getOrCreateList();
        }
        return list;
    }

    public static Supplier<BeeIngredient> getIngredient(String name) {
        return () -> BeeIngredientFactory.getOrCreateList().get(name);
    }

    public static Map<String, BeeIngredient> getOrCreateList() {
        if (ingredientList.isEmpty()) {
            try {
                for (EntityType entityType : ForgeRegistries.ENTITIES.getValues()) {
                    if (!entityType.func_220341_a((ITag)EntityTypeTags.field_226155_c_) || entityType.equals(ModEntities.CONFIGURABLE_BEE.get())) continue;
                    EntityType bee = entityType;
                    BeeIngredientFactory.addBee(bee.getRegistryName().toString(), new BeeIngredient((EntityType<? extends Entity>)bee));
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (configurableBeeIngredientCount != BeeReloadListener.INSTANCE.getData().size()) {
            configurableBeeIngredientCount = 0;
            for (Map.Entry entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                String beeType = (String)entry.getKey();
                EntityType bee = (EntityType)ModEntities.CONFIGURABLE_BEE.get();
                BeeIngredientFactory.addBee(beeType, new BeeIngredient((EntityType<? extends Entity>)bee, new ResourceLocation(beeType), true));
                ++configurableBeeIngredientCount;
            }
        }
        return ingredientList;
    }

    public static void addBee(String name, BeeIngredient bee) {
        ingredientList.put(name, bee);
    }

    public static Map<String, BeeIngredient> getRBeesIngredients() {
        HashMap<String, BeeIngredient> list = new HashMap<String, BeeIngredient>(BeeIngredientFactory.getOrCreateList());
        list.entrySet().removeIf(entry -> !((String)entry.getKey()).contains("resourcefulbees"));
        return list;
    }
}

