/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class BeeIngredientHelper
implements IIngredientHelper<BeeIngredient> {
    @Nullable
    public BeeIngredient getMatch(Iterable<BeeIngredient> iterable, BeeIngredient beeIngredient) {
        for (BeeIngredient ingredient : iterable) {
            if (ingredient.getBeeType() != beeIngredient.getBeeType()) continue;
            return ingredient;
        }
        return null;
    }

    @Nonnull
    public String getDisplayName(BeeIngredient beeIngredient) {
        CompoundNBT nbt = BeeReloadListener.INSTANCE.getData(beeIngredient.getBeeType().toString());
        if (nbt != null) {
            return new TranslationTextComponent("entity.productivebees.bee_configurable", new Object[]{nbt.func_74779_i("name")}).getString();
        }
        return beeIngredient.getBeeEntity().func_212546_e().getString();
    }

    @Nonnull
    public String getUniqueId(BeeIngredient beeIngredient) {
        return "beeingredient:" + beeIngredient.getBeeType();
    }

    @Nonnull
    public String getWildcardId(@Nonnull BeeIngredient beeIngredient) {
        return this.getUniqueId(beeIngredient);
    }

    @Nonnull
    public String getModId(BeeIngredient beeIngredient) {
        return beeIngredient.getBeeType().func_110624_b();
    }

    @Nonnull
    public String getResourceId(BeeIngredient beeIngredient) {
        return beeIngredient.getBeeType().func_110623_a();
    }

    @Nonnull
    public BeeIngredient copyIngredient(BeeIngredient beeIngredient) {
        return new BeeIngredient(beeIngredient.getBeeEntity(), beeIngredient.getBeeType());
    }

    @Nonnull
    public String getErrorInfo(@Nullable BeeIngredient beeIngredient) {
        if (beeIngredient == null) {
            return "beeingredient:null";
        }
        if (beeIngredient.getBeeEntity() == null) {
            return "beeingredient:bee:null";
        }
        return "beeingredient:" + beeIngredient.getBeeType();
    }
}

