/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.top;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.tileentity.CentrifugeTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.SolitaryNestTileEntity;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TopPlugin
implements Function<ITheOneProbe, Void> {
    ITextComponent formattedName = new StringTextComponent("Productive Bees").func_240699_a_(TextFormatting.BLUE).func_240699_a_(TextFormatting.ITALIC);

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            ResourceLocation registryName;
            TileEntity tileEntity = world.func_175625_s(data.getPos());
            if (tileEntity instanceof SolitaryNestTileEntity) {
                SolitaryNestTileEntity nest = (SolitaryNestTileEntity)tileEntity;
                if (mode.equals((Object)ProbeMode.EXTENDED)) {
                    probeInfo.horizontal().item(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).vertical().itemLabel(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).text(this.formattedName);
                    if (nest.func_226971_j_() > 0) {
                        probeInfo.text((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.bee", new Object[]{nest.getBeeList().get((int)0).localizedName}));
                        probeInfo.progress(nest.getBeeList().get((int)0).minOccupationTicks - nest.getBeeList().get((int)0).ticksInHive, nest.getBeeList().get((int)0).minOccupationTicks);
                    } else if (nest.getNestTickCooldown() > 0) {
                        probeInfo.text((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.repopulation_countdown"));
                        probeInfo.progress(nest.getNestTickCooldown() / 20, (Integer)ProductiveBeesConfig.GENERAL.nestSpawnCooldown.get() / 20);
                    } else {
                        probeInfo.text((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.repopulation_countdown_inactive"));
                        if (nest.canRepopulate()) {
                            probeInfo.text((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.can_repopulate_true"));
                        } else {
                            probeInfo.text((ITextComponent)new TranslationTextComponent("productivebees.top.solitary.can_repopulate_false"));
                        }
                    }
                    return true;
                }
            }
            if (tileEntity instanceof CentrifugeTileEntity) {
                CentrifugeTileEntity centrifugeTileEntity = (CentrifugeTileEntity)tileEntity;
                if (centrifugeTileEntity.recipeProgress > 0) {
                    probeInfo.horizontal().item(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).vertical().itemLabel(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).progress((int)Math.floor(centrifugeTileEntity.recipeProgress), centrifugeTileEntity.getProcessingTime()).text(this.formattedName);
                    return true;
                }
            }
            if ((registryName = blockState.func_177230_c().getRegistryName()) != null && registryName.func_110624_b().equals("productivebees")) {
                probeInfo.horizontal().item(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).vertical().itemLabel(new ItemStack((IItemProvider)blockState.func_177230_c().func_199767_j())).text(this.formattedName);
                return true;
            }
            return false;
        });
        return null;
    }
}

