/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.network.packets;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class Messages {
    private static void updateJEI() {
        ProductiveBees.LOGGER.info("Calling updateJEI");
        block10: for (ServerType type : ServerType.values()) {
            if (!type.connected()) continue;
            switch (type.name) {
                case "integrated": {
                    RecipeManager manager = ProductiveBees.proxy.getWorld().func_199532_z();
                    ForgeHooksClient.onRecipesUpdated((RecipeManager)manager);
                    continue block10;
                }
                case "vanilla": {
                    MinecraftForge.EVENT_BUS.post((Event)new TagsUpdatedEvent.VanillaTagTypes(ProductiveBees.proxy.getWorld().func_205772_D()));
                    continue block10;
                }
                case "modded": {
                    MinecraftForge.EVENT_BUS.post((Event)new TagsUpdatedEvent.CustomTagTypes(ProductiveBees.proxy.getWorld().func_205772_D()));
                }
            }
        }
    }

    private static enum ServerType {
        INTEGRATED("integrated", false, true),
        VANILLA_REMOTE("vanilla", true, false),
        MODDED_REMOTE("modded", false, false);

        public final String name;
        public final boolean isVanilla;
        public final boolean isIntegrated;

        private ServerType(String name, boolean isVanilla, boolean isIntegrated) {
            this.name = name;
            this.isVanilla = isVanilla;
            this.isIntegrated = isIntegrated;
        }

        public boolean connected() {
            ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
            boolean isVanilla = connection != null && NetworkHooks.isVanillaConnection((NetworkManager)connection.func_147298_b());
            boolean isIntegrated = Minecraft.func_71410_x().func_71356_B();
            return isVanilla == this.isVanilla && isIntegrated == this.isIntegrated;
        }
    }

    public static class ReindexMessage {
        public static void encode(ReindexMessage message, PacketBuffer buffer) {
        }

        public static ReindexMessage decode(PacketBuffer buffer) {
            return new ReindexMessage();
        }

        public static void handle(ReindexMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ProductiveBees.LOGGER.debug("trigger recipe reload (bees:" + BeeReloadListener.INSTANCE.getData().size() + ")");
                Messages.updateJEI();
            });
            context.get().setPacketHandled(true);
        }
    }

    public static class BeeDataMessage {
        public Map<String, CompoundNBT> data;

        public BeeDataMessage(Map<String, CompoundNBT> data) {
            this.data = data;
        }

        public static void encode(BeeDataMessage message, PacketBuffer buffer) {
            buffer.writeInt(message.data.size());
            for (Map.Entry<String, CompoundNBT> entry : message.data.entrySet()) {
                buffer.func_180714_a(entry.getKey());
                buffer.func_150786_a(entry.getValue());
            }
        }

        public static BeeDataMessage decode(PacketBuffer buffer) {
            HashMap<String, CompoundNBT> data = new HashMap<String, CompoundNBT>();
            IntStream.range(0, buffer.readInt()).forEach(i -> data.put(buffer.func_218666_n(), buffer.func_244273_m()));
            return new BeeDataMessage(data);
        }

        public static void handle(BeeDataMessage message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                BeeReloadListener.INSTANCE.setData(message.data);
                int delay = (Integer)ProductiveBeesConfig.GENERAL.beeSyncDelay.get();
                if (delay == 0) {
                    Messages.updateJEI();
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

