/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.recipe.TagOutputRecipe;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AdvancedBeehiveRecipe
extends TagOutputRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<AdvancedBeehiveRecipe> ADVANCED_BEEHIVE = IRecipeType.func_222147_a((String)"productivebees:advanced_beehive");
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> ingredient;

    public AdvancedBeehiveRecipe(ResourceLocation id, Lazy<BeeIngredient> ingredient, Map<Ingredient, IntArrayNBT> itemOutput) {
        super(itemOutput);
        this.id = id;
        this.ingredient = ingredient;
    }

    public String toString() {
        return "AdvancedBeehiveRecipe{id=" + this.id + ", bee=" + ((BeeIngredient)this.ingredient.get()).getBeeEntity() + '}';
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory && this.ingredient.get() != null) {
            String beeName = ((BeeHelper.IdentifierInventory)inv).getIdentifier();
            return beeName.equals(((BeeIngredient)this.ingredient.get()).getBeeType().toString());
        }
        if (this.ingredient.get() == null) {
            ProductiveBees.LOGGER.info(this.id + " is null");
        }
        return false;
    }

    @Override
    public Map<ItemStack, IntArrayNBT> getRecipeOutputs() {
        Map<ItemStack, IntArrayNBT> output = super.getRecipeOutputs();
        for (Map.Entry<ItemStack, IntArrayNBT> entry : output.entrySet()) {
            if (!((BeeIngredient)this.ingredient.get()).isConfigurable() || !entry.getKey().func_77973_b().equals(ModItems.CONFIGURABLE_HONEYCOMB.get())) continue;
            BeeCreator.setTag(((BeeIngredient)this.ingredient.get()).getBeeType().toString(), entry.getKey());
        }
        return output;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.ADVANCED_BEEHIVE.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return ADVANCED_BEEHIVE;
    }

    public static class Serializer<T extends AdvancedBeehiveRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String beeName = JSONUtils.func_151200_h((JsonObject)json, (String)"ingredient");
            Lazy beeIngredient = Lazy.of(BeeIngredientFactory.getIngredient(beeName));
            LinkedHashMap<Ingredient, IntArrayNBT> itemOutputs = new LinkedHashMap<Ingredient, IntArrayNBT>();
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"results");
            jsonArray.forEach(jsonElement -> {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String ingredientKey = jsonObject.has("item") ? "item" : "comb_produce";
                Ingredient produce = JSONUtils.func_151202_d((JsonObject)jsonObject, (String)ingredientKey) ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)jsonObject, (String)ingredientKey)) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)ingredientKey));
                int min = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"min", (int)1);
                int max = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"max", (int)1);
                int outputChance = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"chance", (int)100);
                IntArrayNBT nbt = new IntArrayNBT(new int[]{min, max, outputChance});
                itemOutputs.put(produce, nbt);
            });
            return this.factory.create(id, (Lazy<BeeIngredient>)beeIngredient, itemOutputs);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                BeeIngredient ingredient = BeeIngredient.fromNetwork(buffer);
                LinkedHashMap<Ingredient, IntArrayNBT> itemOutput = new LinkedHashMap<Ingredient, IntArrayNBT>();
                IntStream.range(0, buffer.readInt()).forEach(i -> itemOutput.put(Ingredient.func_199566_b((PacketBuffer)buffer), new IntArrayNBT(new int[]{buffer.readInt(), buffer.readInt(), buffer.readInt()})));
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> ingredient), itemOutput);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading beehive produce recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                if (((AdvancedBeehiveRecipe)recipe).ingredient.get() == null) {
                    throw new RuntimeException("Bee produce recipe ingredient missing " + ((AdvancedBeehiveRecipe)recipe).func_199560_c() + " - " + ((AdvancedBeehiveRecipe)recipe).ingredient);
                }
                ((BeeIngredient)((AdvancedBeehiveRecipe)recipe).ingredient.get()).toNetwork(buffer);
                buffer.writeInt(((AdvancedBeehiveRecipe)recipe).itemOutput.size());
                ((AdvancedBeehiveRecipe)recipe).itemOutput.forEach((key, value) -> {
                    key.func_199564_a(buffer);
                    buffer.writeInt(value.get(0).func_150287_d());
                    buffer.writeInt(value.get(1).func_150287_d());
                    buffer.writeInt(value.get(2).func_150287_d());
                });
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing beehive produce recipe to packet. " + ((AdvancedBeehiveRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends AdvancedBeehiveRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, Map<Ingredient, IntArrayNBT> var3);
        }
    }
}

