/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeBlockReplacerRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BeeBlockReplacerRecipe> BEE_BLOCK_REPLACER = IRecipeType.func_222147_a((String)"productivebees:bee_block_replacer");
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> source;
    public final Lazy<BeeIngredient> result;
    public final Ingredient item;
    public final int chance;

    public BeeBlockReplacerRecipe(ResourceLocation id, Lazy<BeeIngredient> ingredients, Lazy<BeeIngredient> result, Ingredient item, int chance) {
        this.id = id;
        this.source = ingredients;
        this.result = result;
        this.item = item;
        this.chance = chance;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory && this.source.get() != null) {
            String beeName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String itemName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            String parentName = ((BeeIngredient)this.source.get()).getBeeType().toString();
            boolean matchesItem = false;
            for (ItemStack stack : this.item.func_193365_a()) {
                if (!stack.func_77973_b().getRegistryName().toString().equals(itemName)) continue;
                matchesItem = true;
            }
            return parentName.equals(beeName) && matchesItem;
        }
        ProductiveBees.LOGGER.warn("conversion recipe source is null " + this);
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_CONVERSION.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BEE_BLOCK_REPLACER;
    }

    public static class Serializer<T extends BeeBlockReplacerRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String source = JSONUtils.func_151200_h((JsonObject)json, (String)"source");
            String result = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(source));
            Lazy resultBee = Lazy.of(BeeIngredientFactory.getIngredient(result));
            Ingredient item = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"item")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"item"));
            int chance = JSONUtils.func_151208_a((JsonObject)json, (String)"chance", (int)100);
            return this.factory.create(id, (Lazy<BeeIngredient>)sourceBee, (Lazy<BeeIngredient>)resultBee, item, chance);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                BeeIngredient source = BeeIngredient.fromNetwork(buffer);
                BeeIngredient result = BeeIngredient.fromNetwork(buffer);
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> source), (Lazy<BeeIngredient>)Lazy.of(() -> result), Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                ((BeeIngredient)((BeeBlockReplacerRecipe)recipe).source.get()).toNetwork(buffer);
                ((BeeIngredient)((BeeBlockReplacerRecipe)recipe).result.get()).toNetwork(buffer);
                ((BeeBlockReplacerRecipe)recipe).item.func_199564_a(buffer);
                buffer.writeInt(((BeeBlockReplacerRecipe)recipe).chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet. " + ((BeeBlockReplacerRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeBlockReplacerRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, Lazy<BeeIngredient> var3, Ingredient var4, int var5);
        }
    }
}

