/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.item.BeeBomb;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeBombBeeCageRecipe
implements ICraftingRecipe {
    public final ResourceLocation id;
    public final ItemStack beeBomb;

    public BeeBombBeeCageRecipe(ResourceLocation id, ItemStack beeBomb) {
        this.id = id;
        this.beeBomb = beeBomb;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack beeBombStack = null;
        int beeCount = 0;
        int bombBeeCount = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (beeBombStack == null && (itemstack.func_77973_b().equals(ModItems.BEE_BOMB.get()) || itemstack.func_77973_b().equals(ModItems.BEE_BOMB_ANGRY.get()))) {
                beeBombStack = itemstack;
                ListNBT bees = BeeBomb.getBees(beeBombStack);
                beeCount += bees.size();
                bombBeeCount = bees.size();
                continue;
            }
            if (itemstack.func_77973_b().equals(ModItems.BEE_CAGE.get()) && BeeCage.isFilled(itemstack)) {
                ++beeCount;
                continue;
            }
            return false;
        }
        if (beeBombStack == null) {
            return false;
        }
        if (bombBeeCount == beeCount) {
            return false;
        }
        return beeCount > 0 && beeCount <= (Integer)ProductiveBeesConfig.GENERAL.numberOfBeesPerBomb.get();
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        ItemStack bomb = null;
        ArrayList<ItemStack> beeCages = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b().equals(ModItems.BEE_BOMB.get()) || itemstack.func_77973_b().equals(ModItems.BEE_BOMB_ANGRY.get())) {
                bomb = itemstack;
                continue;
            }
            if (!itemstack.func_77973_b().equals(ModItems.BEE_CAGE.get())) continue;
            beeCages.add(itemstack);
        }
        if (bomb != null) {
            ItemStack beeBomb = bomb.func_77946_l();
            beeCages.forEach(beeCage -> BeeBomb.addBee(beeBomb, beeCage));
            beeBomb.func_190920_e(1);
            return beeBomb;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.beeBomb;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.beeBomb.func_77946_l()}));
        ItemStack cage = new ItemStack((IItemProvider)ModItems.BEE_CAGE.get());
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("entity", EntityType.func_200718_a((EntityType)EntityType.field_226289_e_).toString());
        cage.func_77982_d(nbt);
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{cage}));
        return list;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_CAGE_BOMB.get();
    }

    public static class Serializer<T extends BeeBombBeeCageRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id, new ItemStack((IItemProvider)ModItems.BEE_BOMB.get()));
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                return this.factory.create(id, buffer.func_150791_c());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee bomb cage recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                buffer.func_150788_a(((BeeBombBeeCageRecipe)recipe).beeBomb);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee bomb cage recipe to packet. " + ((BeeBombBeeCageRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeBombBeeCageRecipe> {
            public T create(ResourceLocation var1, ItemStack var2);
        }
    }
}

