/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeeNBTChangerRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BeeNBTChangerRecipe> BEE_NBT_CHANGER = IRecipeType.func_222147_a((String)"productivebees:bee_nbt_changer");
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> bee;
    public final Ingredient item;
    public String attribute;
    public String method;
    public int value;
    public int min;
    public int max;

    public BeeNBTChangerRecipe(ResourceLocation id, Lazy<BeeIngredient> ingredients, Ingredient item, String attribute, String method, int value, int min, int max) {
        this.id = id;
        this.bee = ingredients;
        this.item = item;
        this.attribute = attribute;
        this.method = method;
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory && this.bee.get() != null) {
            String beeName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String itemName = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            String parentName = ((BeeIngredient)this.bee.get()).getBeeType().toString();
            boolean matchesItem = false;
            for (ItemStack stack : this.item.func_193365_a()) {
                if (!stack.func_77973_b().getRegistryName().toString().equals(itemName)) continue;
                matchesItem = true;
            }
            return parentName.equals(beeName) && matchesItem;
        }
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BEE_NBT_CHANGER.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BEE_NBT_CHANGER;
    }

    public static class Serializer<T extends BeeNBTChangerRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String beeName = JSONUtils.func_151200_h((JsonObject)json, (String)"bee");
            Lazy bee = Lazy.of(BeeIngredientFactory.getIngredient(beeName));
            Ingredient item = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"item")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"item"));
            String attribute = JSONUtils.func_151200_h((JsonObject)json, (String)"attribute");
            String method = JSONUtils.func_151200_h((JsonObject)json, (String)"method");
            int value = JSONUtils.func_151208_a((JsonObject)json, (String)"value", (int)0);
            int min = JSONUtils.func_151208_a((JsonObject)json, (String)"min", (int)0);
            int max = JSONUtils.func_151208_a((JsonObject)json, (String)"max", (int)100);
            return this.factory.create(id, (Lazy<BeeIngredient>)bee, item, attribute, method, value, min, max);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                BeeIngredient bee = BeeIngredient.fromNetwork(buffer);
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> bee), Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_218666_n(), buffer.func_218666_n(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                ((BeeIngredient)((BeeNBTChangerRecipe)recipe).bee.get()).toNetwork(buffer);
                ((BeeNBTChangerRecipe)recipe).item.func_199564_a(buffer);
                buffer.func_180714_a(((BeeNBTChangerRecipe)recipe).attribute);
                buffer.func_180714_a(((BeeNBTChangerRecipe)recipe).method);
                buffer.writeInt(((BeeNBTChangerRecipe)recipe).value);
                buffer.writeInt(((BeeNBTChangerRecipe)recipe).min);
                buffer.writeInt(((BeeNBTChangerRecipe)recipe).max);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet. " + ((BeeNBTChangerRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BeeNBTChangerRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, Ingredient var3, String var4, String var5, int var6, int var7, int var8);
        }
    }
}

