/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlockConversionRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BlockConversionRecipe> BLOCK_CONVERSION = IRecipeType.func_222147_a((String)"productivebees:block_conversion");
    public final ResourceLocation id;
    public final Lazy<BeeIngredient> bee;
    public final BlockState stateFrom;
    public final BlockState stateTo;
    public final int chance;

    public BlockConversionRecipe(ResourceLocation id, Lazy<BeeIngredient> bee, BlockState from, BlockState to, int chance) {
        this.id = id;
        this.bee = bee;
        this.stateFrom = from;
        this.stateTo = to;
        this.chance = chance;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (inv instanceof BeeHelper.BlockStateInventory && this.bee.get() != null) {
            String beeName = ((BeeHelper.BlockStateInventory)inv).getIdentifier(0);
            BlockState blockState = ((BeeHelper.BlockStateInventory)inv).getState();
            return ((BeeIngredient)this.bee.get()).getBeeType().toString().equals(beeName) && blockState.equals(this.stateFrom);
        }
        ProductiveBees.LOGGER.warn("conversion recipe source is null " + this);
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BLOCK_CONVERSION.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BLOCK_CONVERSION;
    }

    private static BlockState jsonToBlockState(JsonObject json) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("Name", JSONUtils.func_151200_h((JsonObject)json, (String)"Name"));
        if (json.has("Properties")) {
            CompoundNBT propertyTag = new CompoundNBT();
            JsonObject properties = JSONUtils.func_152754_s((JsonObject)json, (String)"Properties");
            for (Map.Entry entry : properties.entrySet()) {
                propertyTag.func_74778_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            tag.func_218657_a("Properties", (INBT)propertyTag);
        }
        return NBTUtil.func_190008_d((CompoundNBT)tag);
    }

    public static class Serializer<T extends BlockConversionRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            String source = JSONUtils.func_151200_h((JsonObject)json, (String)"bee");
            Lazy sourceBee = Lazy.of(BeeIngredientFactory.getIngredient(source));
            BlockState from = BlockConversionRecipe.jsonToBlockState(json.getAsJsonObject("from"));
            BlockState to = BlockConversionRecipe.jsonToBlockState(json.getAsJsonObject("to"));
            int chance = JSONUtils.func_151208_a((JsonObject)json, (String)"chance", (int)100);
            return this.factory.create(id, (Lazy<BeeIngredient>)sourceBee, from, to, chance);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                BeeIngredient source = BeeIngredient.fromNetwork(buffer);
                BlockState from = NBTUtil.func_190008_d((CompoundNBT)buffer.func_244273_m());
                BlockState to = NBTUtil.func_190008_d((CompoundNBT)buffer.func_244273_m());
                return this.factory.create(id, (Lazy<BeeIngredient>)Lazy.of(() -> source), from, to, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                ((BeeIngredient)((BlockConversionRecipe)recipe).bee.get()).toNetwork(buffer);
                buffer.func_150786_a(NBTUtil.func_190009_a((BlockState)((BlockConversionRecipe)recipe).stateFrom));
                buffer.func_150786_a(NBTUtil.func_190009_a((BlockState)((BlockConversionRecipe)recipe).stateTo));
                buffer.writeInt(((BlockConversionRecipe)recipe).chance);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet. " + ((BlockConversionRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BlockConversionRecipe> {
            public T create(ResourceLocation var1, Lazy<BeeIngredient> var2, BlockState var3, BlockState var4, int var5);
        }
    }
}

