/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.recipe.TagOutputRecipe;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BottlerRecipe
extends TagOutputRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<BottlerRecipe> BOTTLER = IRecipeType.func_222147_a((String)"productivebees:bottler");
    public final ResourceLocation id;
    public final Pair<String, Integer> fluidInput;
    public final Ingredient itemInput;
    public final Ingredient result;

    public BottlerRecipe(ResourceLocation id, Pair<String, Integer> fluidInput, Ingredient itemInput, Ingredient result) {
        super(result);
        this.id = id;
        this.fluidInput = fluidInput;
        this.itemInput = itemInput;
        this.result = result;
    }

    public boolean matches(FluidStack fluid, ItemStack inputStack) {
        if (!this.itemInput.test(inputStack)) {
            return false;
        }
        if (!BottlerRecipe.getPreferredFluidByMod((String)this.fluidInput.getFirst()).equals(fluid.getFluid())) {
            return false;
        }
        return fluid.getAmount() >= (Integer)this.fluidInput.getSecond();
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.getRecipeOutputs().entrySet().iterator().next().getKey().func_77946_l();
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.BOTTLER.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return BOTTLER;
    }

    public static class Serializer<T extends BottlerRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Pair fluidInput = null;
            if (json.has("fluid")) {
                int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)250);
                JsonObject fluid = JSONUtils.func_152754_s((JsonObject)json, (String)"fluid");
                String fluidResourceLocation = "";
                if (fluid.has("tag")) {
                    fluidResourceLocation = JSONUtils.func_151200_h((JsonObject)fluid, (String)"tag");
                } else if (fluid.has("fluid")) {
                    fluidResourceLocation = JSONUtils.func_151200_h((JsonObject)fluid, (String)"fluid");
                }
                fluidInput = Pair.of((Object)fluidResourceLocation, (Object)amount);
            }
            Ingredient input = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"input")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
            Ingredient output = JSONUtils.func_151202_d((JsonObject)json, (String)"output") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"output")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            return this.factory.create(id, (Pair<String, Integer>)fluidInput, input, output);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                Pair fluidInput = Pair.of((Object)buffer.func_218666_n(), (Object)buffer.readInt());
                return this.factory.create(id, (Pair<String, Integer>)fluidInput, Ingredient.func_199566_b((PacketBuffer)buffer), Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee bottler recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                buffer.func_180714_a((String)((BottlerRecipe)recipe).fluidInput.getFirst());
                buffer.writeInt(((Integer)((BottlerRecipe)recipe).fluidInput.getSecond()).intValue());
                ((BottlerRecipe)recipe).itemInput.func_199564_a(buffer);
                ((BottlerRecipe)recipe).result.func_199564_a(buffer);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee bottler recipe to packet. " + ((BottlerRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends BottlerRecipe> {
            public T create(ResourceLocation var1, Pair<String, Integer> var2, Ingredient var3, Ingredient var4);
        }
    }
}

