/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.recipe.TagOutputRecipe;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CentrifugeRecipe
extends TagOutputRecipe
implements IRecipe<IInventory> {
    public static final IRecipeType<CentrifugeRecipe> CENTRIFUGE = IRecipeType.func_222147_a((String)"productivebees:centrifuge");
    public final ResourceLocation id;
    public final Ingredient ingredient;
    public final Map<String, Integer> fluidOutput;

    public CentrifugeRecipe(ResourceLocation id, Ingredient ingredient, Map<Ingredient, IntArrayNBT> itemOutput, Map<String, Integer> fluidOutput) {
        super(itemOutput);
        this.id = id;
        this.ingredient = ingredient;
        this.fluidOutput = fluidOutput;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        if (this.ingredient.func_193365_a().length > 0) {
            ItemStack invStack = inv.func_70301_a(1);
            for (ItemStack stack : this.ingredient.func_193365_a()) {
                if (!stack.func_77973_b().equals(invStack.func_77973_b())) continue;
                if (stack.func_77942_o() && invStack.func_77942_o()) {
                    return stack.func_77978_p().equals((Object)invStack.func_77978_p());
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nullable
    public Pair<Fluid, Integer> getFluidOutputs() {
        for (Map.Entry<String, Integer> entry : this.fluidOutput.entrySet()) {
            Fluid fluid = CentrifugeRecipe.getPreferredFluidByMod(entry.getKey());
            if (fluid == Fluids.field_204541_a) continue;
            return Pair.of((Object)fluid, (Object)entry.getValue());
        }
        return null;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.CENTRIFUGE.get();
    }

    @Nonnull
    public IRecipeType<?> func_222127_g() {
        return CENTRIFUGE;
    }

    public static class Serializer<T extends CentrifugeRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            String type = JSONUtils.func_151219_a((JsonObject)json, (String)"comb_type", (String)"");
            if (!type.isEmpty()) {
                ItemStack stack = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_HONEYCOMB.get());
                BeeCreator.setTag(type, stack);
                ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            }
            JsonArray jsonArray = JSONUtils.func_151214_t((JsonObject)json, (String)"outputs");
            LinkedHashMap<Ingredient, IntArrayNBT> itemOutputs = new LinkedHashMap<Ingredient, IntArrayNBT>();
            LinkedHashMap<String, Integer> fluidOutputs = new LinkedHashMap<String, Integer>();
            jsonArray.forEach(el -> {
                JsonObject jsonObject = el.getAsJsonObject();
                if (jsonObject.has("item")) {
                    int min = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"min", (int)1);
                    int max = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"max", (int)1);
                    int chance = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"chance", (int)100);
                    IntArrayNBT nbt = new IntArrayNBT(new int[]{min, max, chance});
                    Ingredient produce = JSONUtils.func_151202_d((JsonObject)jsonObject, (String)"item") ? Ingredient.func_199802_a((JsonElement)JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"item")) : Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"item"));
                    itemOutputs.put(produce, nbt);
                } else if (jsonObject.has("fluid")) {
                    int amount = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"amount", (int)250);
                    JsonObject fluid = JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"fluid");
                    String fluidResourceLocation = "";
                    if (fluid.has("tag")) {
                        fluidResourceLocation = JSONUtils.func_151200_h((JsonObject)fluid, (String)"tag");
                    } else if (fluid.has("fluid")) {
                        fluidResourceLocation = JSONUtils.func_151200_h((JsonObject)fluid, (String)"fluid");
                    }
                    fluidOutputs.put(fluidResourceLocation, amount);
                }
            });
            if (fluidOutputs.isEmpty()) {
                fluidOutputs.put("productivebees:honey", 100);
            }
            return this.factory.create(id, ingredient, itemOutputs, fluidOutputs);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                LinkedHashMap<Ingredient, IntArrayNBT> itemOutput = new LinkedHashMap<Ingredient, IntArrayNBT>();
                IntStream.range(0, buffer.readInt()).forEach(i -> itemOutput.put(Ingredient.func_199566_b((PacketBuffer)buffer), new IntArrayNBT(new int[]{buffer.readInt(), buffer.readInt(), buffer.readInt()})));
                LinkedHashMap<String, Integer> fluidOutput = new LinkedHashMap<String, Integer>();
                IntStream.range(0, buffer.readInt()).forEach(i -> fluidOutput.put(buffer.func_218666_n(), buffer.readInt()));
                return this.factory.create(id, ingredient, itemOutput, fluidOutput);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading centrifuge recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, @Nonnull T recipe) {
            try {
                ((CentrifugeRecipe)recipe).ingredient.func_199564_a(buffer);
                buffer.writeInt(((CentrifugeRecipe)recipe).itemOutput.size());
                ((CentrifugeRecipe)recipe).itemOutput.forEach((key, value) -> {
                    key.func_199564_a(buffer);
                    buffer.writeInt(value.get(0).func_150287_d());
                    buffer.writeInt(value.get(1).func_150287_d());
                    buffer.writeInt(value.get(2).func_150287_d());
                });
                buffer.writeInt(((CentrifugeRecipe)recipe).fluidOutput.size());
                ((CentrifugeRecipe)recipe).fluidOutput.forEach((key, value) -> {
                    buffer.func_180714_a(key);
                    buffer.writeInt(value.intValue());
                });
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing centrifuge recipe to packet. " + ((CentrifugeRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends CentrifugeRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Map<Ingredient, IntArrayNBT> var3, Map<String, Integer> var4);
        }
    }
}

