/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CombineGeneRecipe
implements ICraftingRecipe {
    public final ResourceLocation id;

    public CombineGeneRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int numberOfIngredients = 0;
        Pair addedGene = null;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b().equals(ModItems.GENE.get())) {
                ++numberOfIngredients;
                String attribute = Gene.getAttributeName(itemstack);
                if (addedGene == null) {
                    addedGene = Pair.of((Object)attribute, (Object)Gene.getValue(itemstack));
                    continue;
                }
                if (((String)addedGene.getFirst()).equals(attribute) && ((Integer)addedGene.getSecond()).equals(Gene.getValue(itemstack)) && Gene.getPurity(itemstack) != 100) continue;
                return false;
            }
            return false;
        }
        return numberOfIngredients > 1;
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        String attribute = null;
        int value = 0;
        int purity = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b() || !itemstack.func_77973_b().equals(ModItems.GENE.get())) continue;
            attribute = Gene.getAttributeName(itemstack);
            value = Gene.getValue(itemstack);
            purity = Math.min(100, purity + Gene.getPurity(itemstack));
        }
        if (attribute != null) {
            return Gene.getStack(attribute, value, 1, purity);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)ModItems.GENE.get());
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.GENE.get())}));
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.GENE.get())}));
        return list;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.GENE_GENE.get();
    }

    public static class Serializer<T extends CombineGeneRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                return this.factory.create(id);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading gene recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
        }

        public static interface IRecipeFactory<T extends CombineGeneRecipe> {
            public T create(ResourceLocation var1);
        }
    }
}

