/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ConfigurableCombBlockRecipe
implements ICraftingRecipe {
    public final ResourceLocation id;
    public final Integer count;

    public ConfigurableCombBlockRecipe(ResourceLocation id, Integer count) {
        this.id = id;
        this.count = count;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() == 1 && stacks.get(0).func_77973_b().equals(ModItems.CONFIGURABLE_COMB_BLOCK.get())) {
            return stacks.get(0).func_77942_o();
        }
        return false;
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() > 0) {
            ItemStack inStack = stacks.get(0);
            ItemStack outStack = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_HONEYCOMB.get(), this.count.intValue());
            outStack.func_77982_d(inStack.func_77978_p());
            return outStack;
        }
        return ItemStack.field_190927_a;
    }

    private List<ItemStack> getItemsInInventory(CraftingInventory inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)ModItems.CONFIGURABLE_HONEYCOMB.get(), this.count.intValue());
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        nonnulllist.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.CONFIGURABLE_COMB_BLOCK.get()}));
        return nonnulllist;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.CONFIGURABLE_COMB_BLOCK.get();
    }

    public static class Serializer<T extends ConfigurableCombBlockRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Integer count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)4);
            return this.factory.create(id, count);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                return this.factory.create(id, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading config comb block recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                buffer.writeInt(((ConfigurableCombBlockRecipe)recipe).count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing config comb block recipe to packet. " + ((ConfigurableCombBlockRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends ConfigurableCombBlockRecipe> {
            public T create(ResourceLocation var1, Integer var2);
        }
    }
}

