/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ConfigurableHoneycombRecipe
implements ICraftingRecipe {
    public final ResourceLocation id;
    public final Integer count;

    public ConfigurableHoneycombRecipe(ResourceLocation id, Integer count) {
        this.id = id;
        this.count = count;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        CompoundNBT type = null;
        if (stacks.size() == this.count.intValue()) {
            for (ItemStack itemstack : stacks) {
                if (!itemstack.func_190926_b() && itemstack.func_77973_b().equals(ModItems.CONFIGURABLE_HONEYCOMB.get()) && itemstack.func_77942_o()) {
                    if (type == null) {
                        type = itemstack.func_77978_p();
                    }
                    if (type == null || type.equals((Object)itemstack.func_77978_p())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() > 0) {
            ItemStack inStack = stacks.get(0);
            ItemStack outStack = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            outStack.func_77982_d(inStack.func_77978_p());
            return outStack;
        }
        return ItemStack.field_190927_a;
    }

    private List<ItemStack> getItemsInInventory(CraftingInventory inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.count;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)ModItems.CONFIGURABLE_COMB_BLOCK.get());
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (int i = 0; i < this.count; ++i) {
            nonnulllist.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.CONFIGURABLE_HONEYCOMB.get())}));
        }
        return nonnulllist;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.CONFIGURABLE_HONEYCOMB.get();
    }

    public static class Serializer<T extends ConfigurableHoneycombRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Integer count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)4);
            return this.factory.create(id, count);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                return this.factory.create(id, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading config honeycomb recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                buffer.writeInt(((ConfigurableHoneycombRecipe)recipe).count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing config honeycomb recipe to packet. " + ((ConfigurableHoneycombRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends ConfigurableHoneycombRecipe> {
            public T create(ResourceLocation var1, Integer var2);
        }
    }
}

