/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HoneyTreatGeneRecipe
implements ICraftingRecipe {
    public final ResourceLocation id;
    public final ItemStack honeyTreat;

    public HoneyTreatGeneRecipe(ResourceLocation id, ItemStack honeyTreat) {
        this.id = id;
        this.honeyTreat = honeyTreat;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        HashMap<String, Integer> addedGenes = new HashMap<String, Integer>();
        ItemStack honeyTreatStack = null;
        boolean hasAddedGenes = false;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b().equals(ModItems.HONEY_TREAT.get()) && honeyTreatStack == null) {
                honeyTreatStack = itemstack;
                ListNBT genes = HoneyTreat.getGenes(honeyTreatStack);
                for (INBT inbt : genes) {
                    ItemStack insertedGene = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt));
                    String attribute = Gene.getAttributeName(insertedGene);
                    if (addedGenes.containsKey(attribute) && !((Integer)addedGenes.get(attribute)).equals(Gene.getValue(insertedGene))) {
                        return false;
                    }
                    addedGenes.put(attribute, Gene.getValue(insertedGene));
                }
                continue;
            }
            if (itemstack.func_77973_b().equals(ModItems.GENE.get())) {
                String attribute = Gene.getAttributeName(itemstack);
                if (addedGenes.containsKey(attribute) && !((Integer)addedGenes.get(attribute)).equals(Gene.getValue(itemstack))) {
                    return false;
                }
                addedGenes.put(attribute, Gene.getValue(itemstack));
                hasAddedGenes = true;
                continue;
            }
            return false;
        }
        if (honeyTreatStack == null) {
            return false;
        }
        return hasAddedGenes;
    }

    @Nonnull
    public ItemStack assemble(CraftingInventory inv) {
        ItemStack treat = null;
        ArrayList<ItemStack> genes = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            if (itemstack.func_77973_b().equals(ModItems.HONEY_TREAT.get())) {
                treat = itemstack;
                continue;
            }
            if (!itemstack.func_77973_b().equals(ModItems.GENE.get())) continue;
            genes.add(itemstack);
        }
        if (treat != null) {
            ItemStack honeyTreat = treat.func_77946_l();
            genes.forEach(gene -> HoneyTreat.addGene(honeyTreat, gene));
            honeyTreat.func_190920_e(1);
            return honeyTreat;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.honeyTreat;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.honeyTreat.func_77946_l()}));
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.GENE.get())}));
        return list;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.GENE_TREAT.get();
    }

    public static class Serializer<T extends HoneyTreatGeneRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            return this.factory.create(id, new ItemStack((IItemProvider)ModItems.HONEY_TREAT.get()));
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            try {
                return this.factory.create(id, buffer.func_150791_c());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading honey treat gene recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull PacketBuffer buffer, T recipe) {
            try {
                buffer.func_150788_a(((HoneyTreatGeneRecipe)recipe).honeyTreat);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing honey treat gene recipe to packet. " + ((HoneyTreatGeneRecipe)recipe).func_199560_c(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends HoneyTreatGeneRecipe> {
            public T create(ResourceLocation var1, ItemStack var2);
        }
    }
}

