/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.setup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.integrations.patchouli.ProductiveBeesPatchouli;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModList;

public class BeeReloadListener
extends JsonReloadListener {
    public static RecipeManager recipeManager;
    private static final Gson GSON;
    public static final BeeReloadListener INSTANCE;
    private Map<String, CompoundNBT> BEE_DATA = new HashMap<String, CompoundNBT>();

    public BeeReloadListener() {
        super(GSON, "productivebees");
    }

    protected void apply(Map<ResourceLocation, JsonElement> dataMap, @Nonnull IResourceManager resourceManager, IProfiler profiler) {
        profiler.func_76320_a("BeeReloadListener");
        HashMap<String, CompoundNBT> data = new HashMap<String, CompoundNBT>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : dataMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                if (!CraftingHelper.processConditions((JsonObject)entry.getValue().getAsJsonObject(), (String)"conditions")) {
                    ProductiveBees.LOGGER.debug("Skipping loading productive bee {} as its conditions were not met", (Object)id);
                    continue;
                }
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.debug("Skipping loading productive bee {} as its conditions were invalid", (Object)id);
                throw e;
            }
            ResourceLocation simpleId = id.func_110623_a().contains("/") ? new ResourceLocation(id.func_110624_b(), id.func_110623_a().substring(id.func_110623_a().lastIndexOf("/") + 1)) : id;
            CompoundNBT nbt = BeeCreator.create(simpleId, entry.getValue().getAsJsonObject());
            data.remove(simpleId.toString());
            data.put(simpleId.toString(), nbt);
            ProductiveBees.LOGGER.debug("Adding to bee data " + simpleId);
        }
        this.setData(data);
        profiler.func_219895_b("BeeReloadListener");
    }

    public CompoundNBT getData(String id) {
        return this.BEE_DATA.get(id);
    }

    public Map<String, CompoundNBT> getData() {
        return this.BEE_DATA;
    }

    public void setData(Map<String, CompoundNBT> data) {
        this.BEE_DATA = data;
        if (ModList.get().isLoaded("patchouli")) {
            ProductiveBeesPatchouli.setBeeFlags();
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        INSTANCE = new BeeReloadListener();
    }
}

