/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.setup;

import cy.jdkdigital.productivebees.client.particle.FallingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.LavaNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PoppingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PortalNectarParticle;
import cy.jdkdigital.productivebees.client.particle.RisingNectarParticle;
import cy.jdkdigital.productivebees.client.render.block.BottlerTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.CentrifugeTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.FeederTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.JarTileEntityRenderer;
import cy.jdkdigital.productivebees.client.render.entity.DyeBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.HoarderBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.RancherBeeRenderer;
import cy.jdkdigital.productivebees.common.item.BeeBomb;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.item.NestLocator;
import cy.jdkdigital.productivebees.container.gui.AdvancedBeehiveScreen;
import cy.jdkdigital.productivebees.container.gui.BottlerScreen;
import cy.jdkdigital.productivebees.container.gui.CatcherScreen;
import cy.jdkdigital.productivebees.container.gui.CentrifugeScreen;
import cy.jdkdigital.productivebees.container.gui.FeederScreen;
import cy.jdkdigital.productivebees.container.gui.HoneyGeneratorScreen;
import cy.jdkdigital.productivebees.container.gui.IncubatorScreen;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleType;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="productivebees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.ADVANCED_BEEHIVE.get()), AdvancedBeehiveScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CENTRIFUGE.get()), CentrifugeScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.POWERED_CENTRIFUGE.get()), CentrifugeScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.BOTTLER.get()), BottlerScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.FEEDER.get()), FeederScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.INCUBATOR.get()), IncubatorScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.CATCHER.get()), CatcherScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerTypes.HONEY_GENERATOR.get()), HoneyGeneratorScreen::new);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.BEE_CAGE.get()), (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity) -> BeeCage.isFilled(stack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.STURDY_BEE_CAGE.get()), (ResourceLocation)new ResourceLocation("filled"), (stack, world, entity) -> BeeCage.isFilled(stack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.BEE_BOMB.get()), (ResourceLocation)new ResourceLocation("loaded"), (stack, world, entity) -> BeeBomb.isLoaded(stack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.HONEY_TREAT.get()), (ResourceLocation)new ResourceLocation("genetic"), (stack, world, entity) -> HoneyTreat.hasGene(stack) ? 1.0f : 0.0f);
        ItemModelsProperties.func_239418_a_((Item)((Item)ModItems.NEST_LOCATOR.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
            private double rotation;
            private double rota;
            private long lastUpdateTick;

            public float call(@Nonnull ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity player) {
                if ((player != null || stack.func_82839_y()) && NestLocator.hasPosition(stack)) {
                    LivingEntity entity;
                    boolean flag = player != null;
                    Object object = entity = flag ? player : stack.func_82836_z();
                    if (world == null && entity != null && entity.field_70170_p instanceof ClientWorld) {
                        world = (ClientWorld)entity.field_70170_p;
                    }
                    BlockPos pos = NestLocator.getPosition(stack);
                    if (entity != null && world != null && pos != null) {
                        double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                        d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                        double d2 = this.getPositionToAngle(pos, (Entity)entity) / 6.2831854820251465;
                        double d0 = 0.5 - (d1 - 0.25 - d2);
                        if (flag) {
                            d0 = this.wobble((World)world, d0);
                        }
                        return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
                    }
                }
                return 0.0f;
            }

            private double wobble(World worldIn, double amount) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = amount - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            private double getFrameRotation(ItemFrameEntity frameEntity) {
                return MathHelper.func_188209_b((int)(180 + frameEntity.func_174811_aO().func_176736_b() * 90));
            }

            private double getPositionToAngle(BlockPos blockpos, Entity entityIn) {
                return Math.atan2((double)blockpos.func_177952_p() - entityIn.func_226281_cx_(), (double)blockpos.func_177958_n() - entityIn.func_226277_ct_());
            }
        });
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.CENTRIFUGE.get()), CentrifugeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.POWERED_CENTRIFUGE.get()), CentrifugeTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.BOTTLER.get()), BottlerTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.FEEDER.get()), FeederTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntityTypes.JAR.get()), JarTileEntityRenderer::new);
        ClientSetup.registerEntityRendering();
        ClientSetup.registerBlockRendering();
    }

    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_FALLING_NECTAR.get(), FallingNectarParticle.FallingNectarFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_RISING_NECTAR.get(), RisingNectarParticle.RisingNectarFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_POPPING_NECTAR.get(), PoppingNectarParticle.PoppingNectarFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_LAVA_NECTAR.get(), LavaNectarParticle.LavaNectarFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.COLORED_PORTAL_NECTAR.get(), PortalNectarParticle.PortalNectarFactory::new);
    }

    private static void registerEntityRendering() {
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            EntityType bee = (EntityType)registryObject.get();
            String key = bee.func_210760_d();
            if (key.contains("dye_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, DyeBeeRenderer::new);
                continue;
            }
            if (key.contains("rancher_bee") || key.contains("farmer_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, RancherBeeRenderer::new);
                continue;
            }
            if (key.contains("hoarder_bee")) {
                RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, HoarderBeeRenderer::new);
                continue;
            }
            RenderingRegistry.registerEntityRenderingHandler((EntityType)bee, ProductiveBeeRenderer::new);
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)registryObject.get()), ProductiveBeeRenderer::new);
        }
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.BEE_BOMB.get()), entity -> new SpriteRenderer(entity, itemRenderer));
    }

    private static void registerBlockRendering() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.COMB_GHOSTLY.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SLIMY_NEST.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BUMBLE_BEE_NEST.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SUGAR_CANE_NEST.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.JAR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get()), (RenderType)RenderType.func_228643_e_());
    }
}

