/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import cy.jdkdigital.productivebees.util.BeeAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;

public class BeeAttributes {
    private static Map<String, BeeAttribute<?>> map = new HashMap();
    public static Map<BeeAttribute<?>, Map<Integer, String>> keyMap = new HashMap();
    public static final BeeAttribute<String> TYPE = BeeAttributes.register("type");
    public static final BeeAttribute<Integer> PRODUCTIVITY = BeeAttributes.register("productivity");
    public static final BeeAttribute<Integer> ENDURANCE = BeeAttributes.register("endurance");
    public static final BeeAttribute<Integer> TEMPER = BeeAttributes.register("temper");
    public static final BeeAttribute<Integer> BEHAVIOR = BeeAttributes.register("behavior");
    public static final BeeAttribute<Integer> WEATHER_TOLERANCE = BeeAttributes.register("weather_tolerance");
    public static final BeeAttribute<ITag<Item>> APHRODISIACS = BeeAttributes.register("aphrodisiacs");
    public static final UUID HEALTH_MOD_ID_WEAK = UUID.nameUUIDFromBytes("productivebees:health_modifier_weak".getBytes());
    public static final UUID HEALTH_MOD_ID_MEDIUM = UUID.nameUUIDFromBytes("productivebees:health_modifier_medium".getBytes());
    public static final UUID HEALTH_MOD_ID_STRONG = UUID.nameUUIDFromBytes("productivebees:health_modifier_strong".getBytes());
    public static final Map<Integer, AttributeModifier> HEALTH_MODS = new HashMap<Integer, AttributeModifier>();

    private static <T> BeeAttribute<T> register(String name) {
        BeeAttribute attribute = new BeeAttribute(new ResourceLocation("productivebees", name));
        map.put(name, attribute);
        return attribute;
    }

    @Nullable
    public static BeeAttribute<?> getAttributeByName(String name) {
        return map.get(name);
    }

    static {
        keyMap.put(PRODUCTIVITY, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(0, "productivebees.information.attribute.productivity.normal");
                this.put(1, "productivebees.information.attribute.productivity.medium");
                this.put(2, "productivebees.information.attribute.productivity.high");
                this.put(3, "productivebees.information.attribute.productivity.very_high");
            }
        });
        keyMap.put(ENDURANCE, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(0, "productivebees.information.attribute.endurance.weak");
                this.put(1, "productivebees.information.attribute.endurance.normal");
                this.put(2, "productivebees.information.attribute.endurance.medium");
                this.put(3, "productivebees.information.attribute.endurance.strong");
            }
        });
        keyMap.put(TEMPER, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(0, "productivebees.information.attribute.temper.passive");
                this.put(1, "productivebees.information.attribute.temper.normal");
                this.put(2, "productivebees.information.attribute.temper.aggressive");
                this.put(3, "productivebees.information.attribute.temper.hostile");
            }
        });
        keyMap.put(BEHAVIOR, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(0, "productivebees.information.attribute.behavior.diurnal");
                this.put(1, "productivebees.information.attribute.behavior.nocturnal");
                this.put(2, "productivebees.information.attribute.behavior.metaturnal");
            }
        });
        keyMap.put(WEATHER_TOLERANCE, (Map<Integer, String>)new HashMap<Integer, String>(){
            {
                this.put(0, "productivebees.information.attribute.weather_tolerance.none");
                this.put(1, "productivebees.information.attribute.weather_tolerance.rain");
                this.put(2, "productivebees.information.attribute.weather_tolerance.any");
            }
        });
        HEALTH_MODS.put(0, new AttributeModifier(HEALTH_MOD_ID_WEAK, "Health mod weak", (double)-0.3f, AttributeModifier.Operation.MULTIPLY_BASE));
        HEALTH_MODS.put(2, new AttributeModifier(HEALTH_MOD_ID_MEDIUM, "Health mod medium", 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
        HEALTH_MODS.put(3, new AttributeModifier(HEALTH_MOD_ID_STRONG, "Health mod strong", 1.0, AttributeModifier.Operation.MULTIPLY_BASE));
    }
}

