/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeEffect;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeCreator {
    public static CompoundNBT create(ResourceLocation id, JsonObject json) {
        CompoundNBT data = new CompoundNBT();
        data.func_74778_a("id", id.toString());
        Color primary = Color.decode(json.has("primaryColor") ? json.get("primaryColor").getAsString() : "#edc343");
        Color secondary = Color.decode(json.has("secondaryColor") ? json.get("secondaryColor").getAsString() : "#804f40");
        data.func_74768_a("primaryColor", primary.getRGB());
        data.func_74768_a("secondaryColor", secondary.getRGB());
        data.func_74778_a("name", json.has("name") ? json.get("name").getAsString() : BeeCreator.idToName(id.func_110623_a()) + " Bee");
        if (json.has("description")) {
            data.func_74778_a("description", json.get("description").getAsString());
        }
        if (json.has("flowerTag") && !json.get("flowerTag").getAsString().isEmpty()) {
            data.func_74778_a("flowerTag", json.get("flowerTag").getAsString());
        } else if (json.has("flowerBlock") && !json.get("flowerBlock").getAsString().isEmpty()) {
            data.func_74778_a("flowerBlock", json.get("flowerBlock").getAsString());
        }
        if (json.has("nestingPreference")) {
            data.func_74778_a("nestingPreference", json.get("nestingPreference").getAsString());
        }
        if (json.has("beeTexture")) {
            data.func_74778_a("beeTexture", json.get("beeTexture").getAsString());
        }
        if (json.has("particleColor")) {
            data.func_74768_a("particleColor", Color.decode(json.get("particleColor").getAsString()).getRGB());
        }
        if (json.has("tertiaryColor")) {
            data.func_74768_a("tertiaryColor", Color.decode(json.get("tertiaryColor").getAsString()).getRGB());
        }
        if (json.has("attackResponse")) {
            data.func_74778_a("attackResponse", json.get("attackResponse").getAsString());
        }
        data.func_74778_a("flowerType", json.has("flowerType") ? json.get("flowerType").getAsString() : "block");
        data.func_74778_a("renderer", json.has("renderer") ? json.get("renderer").getAsString() : "default");
        data.func_74778_a("renderTransform", json.has("renderTransform") ? json.get("renderTransform").getAsString() : "none");
        data.func_74778_a("particleType", json.has("particleType") ? json.get("particleType").getAsString() : "drip");
        data.func_74776_a("size", json.has("size") ? json.get("size").getAsFloat() : 1.0f);
        data.func_74757_a("translucent", json.has("translucent") && json.get("translucent").getAsBoolean() || data.func_74779_i("renderer").equals("translucent_with_center"));
        data.func_74757_a("useGlowLayer", !json.has("useGlowLayer") || json.get("useGlowLayer").getAsBoolean());
        data.func_74757_a("fireproof", json.has("fireproof") && json.get("fireproof").getAsBoolean());
        data.func_74757_a("withered", json.has("withered") && json.get("withered").getAsBoolean());
        data.func_74757_a("blinding", json.has("blinding") && json.get("blinding").getAsBoolean());
        data.func_74757_a("draconic", json.has("draconic") && json.get("draconic").getAsBoolean());
        data.func_74757_a("slimy", json.has("slimy") && json.get("slimy").getAsBoolean());
        data.func_74757_a("teleporting", json.has("teleporting") && json.get("teleporting").getAsBoolean());
        data.func_74757_a("munchies", json.has("munchies") && json.get("munchies").getAsBoolean());
        data.func_74757_a("redstoned", json.has("redstoned") && json.get("redstoned").getAsBoolean());
        data.func_74757_a("stringy", json.has("stringy") && json.get("stringy").getAsBoolean());
        data.func_74757_a("stingless", json.has("stingless") && json.get("stingless").getAsBoolean());
        data.func_74757_a("waterproof", json.has("waterproof") && json.get("waterproof").getAsBoolean());
        data.func_74757_a("selfbreed", !json.has("selfbreed") || json.get("selfbreed").getAsBoolean());
        if (json.has("attributes")) {
            for (Map.Entry entry : json.get("attributes").getAsJsonObject().entrySet()) {
                switch ((String)entry.getKey()) {
                    case "productivity": 
                    case "endurance": 
                    case "temper": 
                    case "behavior": 
                    case "weather_tolerance": {
                        data.func_74768_a((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
                    }
                }
            }
        }
        if (json.has("passiveEffects")) {
            HashMap<Effect, Integer> effects = new HashMap<Effect, Integer>();
            for (JsonElement el : json.get("passiveEffects").getAsJsonArray()) {
                JsonObject effect = el.getAsJsonObject();
                effects.put((Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effect.get("effect").getAsString())), effect.get("duration").getAsInt());
            }
            data.func_218657_a("effect", (INBT)new BeeEffect(effects).serializeNBT());
        }
        data.func_74757_a("createComb", !json.has("createComb") || json.get("createComb").getAsBoolean());
        return data;
    }

    public static String idToName(String givenString) {
        String[] arr = givenString.replace("_", " ").split(" ");
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            sb.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }

    public static void setTag(String type, ItemStack stack) {
        CompoundNBT tag = stack.func_190925_c("EntityTag");
        tag.func_74778_a("type", type);
    }

    public static ItemStack getSpawnEgg(String beeType) {
        ItemStack egg;
        if (BeeReloadListener.INSTANCE.getData(beeType) != null) {
            egg = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_SPAWN_EGG.get());
            BeeCreator.setTag(beeType, egg);
        } else {
            ResourceLocation name = new ResourceLocation(beeType);
            egg = name.func_110624_b().equals("productivebees") ? new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name.func_110624_b(), "spawn_egg_" + name.func_110623_a()))) : new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name.func_110624_b(), name.func_110623_a() + "_spawn_egg")));
        }
        return egg;
    }
}

