/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api;

import com.google.common.collect.LinkedListMultimap;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TooltipSupplier {
    public static final Logger LOGGER = LogManager.getLogger();
    private static Map<JType, LinkedListMultimap<ResourceLocation, Function<ItemStack, Map<String, Double>>>> tooltips = new HashMap<JType, LinkedListMultimap<ResourceLocation, Function<ItemStack, Map<String, Double>>>>();
    private static Map<JType, LinkedListMultimap<ResourceLocation, Function<BlockEntity, Map<String, Double>>>> breakTooltips = new HashMap<JType, LinkedListMultimap<ResourceLocation, Function<BlockEntity, Map<String, Double>>>>();
    private static Map<JType, LinkedListMultimap<ResourceLocation, Function<Entity, Map<String, Double>>>> entityTooltips = new HashMap<JType, LinkedListMultimap<ResourceLocation, Function<Entity, Map<String, Double>>>>();

    public static void registerTooltipData(ResourceLocation res, JType jType, Function<ItemStack, Map<String, Double>> func) {
        if (func == null) {
            LOGGER.info("Supplied Function Null");
            return;
        }
        if (jType == null) {
            LOGGER.info("Supplied JType Null");
            return;
        }
        if (res == null) {
            LOGGER.info("Supplied ResourceLocation Null");
            return;
        }
        if (!tooltips.containsKey((Object)jType)) {
            LOGGER.info("New tooltip category created for: " + jType.toString() + " " + res.toString());
            tooltips.put(jType, (LinkedListMultimap<ResourceLocation, Function<ItemStack, Map<String, Double>>>)LinkedListMultimap.create());
        }
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return;
        }
        tooltips.get((Object)jType).get((Object)res).add(func);
    }

    public static void registerBreakTooltipData(ResourceLocation res, JType jType, Function<BlockEntity, Map<String, Double>> func) {
        if (func == null) {
            LOGGER.info("Supplied Function Null");
            return;
        }
        if (jType == null) {
            LOGGER.info("Supplied JType Null");
            return;
        }
        if (res == null) {
            LOGGER.info("Supplied ResourceLocation Null");
            return;
        }
        if (!breakTooltips.containsKey((Object)jType)) {
            LOGGER.info("New tooltip category created for: " + jType.toString() + " " + res.toString());
            breakTooltips.put(jType, (LinkedListMultimap<ResourceLocation, Function<BlockEntity, Map<String, Double>>>)LinkedListMultimap.create());
        }
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return;
        }
        breakTooltips.get((Object)jType).get((Object)res).add(func);
    }

    public static void registerEntityTooltipData(ResourceLocation res, JType jType, Function<Entity, Map<String, Double>> func) {
        if (func == null) {
            LOGGER.info("Supplied Function Null");
            return;
        }
        if (jType == null) {
            LOGGER.info("Supplied JType Null");
            return;
        }
        if (res == null) {
            LOGGER.info("Supplied ResourceLocation Null");
            return;
        }
        if (!breakTooltips.containsKey((Object)jType)) {
            LOGGER.info("New tooltip category created for: " + jType.toString() + " " + res.toString());
            entityTooltips.put(jType, (LinkedListMultimap<ResourceLocation, Function<Entity, Map<String, Double>>>)LinkedListMultimap.create());
        }
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return;
        }
        entityTooltips.get((Object)jType).get((Object)res).add(func);
    }

    public static boolean tooltipExists(ResourceLocation res, JType jType) {
        if (jType == null) {
            return false;
        }
        if (res == null) {
            return false;
        }
        if (jType.equals((Object)JType.REQ_BREAK) || jType.equals((Object)JType.XP_VALUE_BREAK)) {
            if (!breakTooltips.containsKey((Object)jType)) {
                return false;
            }
            return breakTooltips.get((Object)jType).containsKey((Object)res);
        }
        if (jType.equals((Object)JType.XP_VALUE_BREED) || jType.equals((Object)JType.XP_VALUE_TAME) || jType.equals((Object)JType.XP_VALUE_KILL)) {
            if (!entityTooltips.containsKey((Object)jType)) {
                return false;
            }
            return entityTooltips.get((Object)jType).containsKey((Object)res);
        }
        if (!tooltips.containsKey((Object)jType)) {
            return false;
        }
        return tooltips.get((Object)jType).containsKey((Object)res);
    }

    public static Map<String, Double> getTooltipData(ResourceLocation res, JType jType, ItemStack stack) {
        if (TooltipSupplier.tooltipExists(res, jType)) {
            HashMap<String, Double> suppliedData = new HashMap<String, Double>();
            ArrayList<Map> rawData = new ArrayList<Map>();
            for (Function func : tooltips.get((Object)jType).get((Object)res)) {
                rawData.add((Map)func.apply(stack));
            }
            for (int i = 0; i < rawData.size(); ++i) {
                for (Map.Entry entry : ((Map)rawData.get(i)).entrySet()) {
                    suppliedData.merge((String)entry.getKey(), (Double)entry.getValue(), (o, n) -> o > n ? o : n);
                }
            }
            return suppliedData;
        }
        return XP.getXpBypass(res, jType);
    }

    public static Map<String, Double> getTooltipData(ResourceLocation res, JType jType, BlockEntity tile) {
        if (TooltipSupplier.tooltipExists(res, jType)) {
            HashMap<String, Double> suppliedData = new HashMap<String, Double>();
            ArrayList<Map> rawData = new ArrayList<Map>();
            for (Function func : breakTooltips.get((Object)jType).get((Object)res)) {
                rawData.add((Map)func.apply(tile));
            }
            for (int i = 0; i < rawData.size(); ++i) {
                for (Map.Entry entry : ((Map)rawData.get(i)).entrySet()) {
                    suppliedData.merge((String)entry.getKey(), (Double)entry.getValue(), (o, n) -> o > n ? o : n);
                }
            }
            return suppliedData;
        }
        return XP.getXpBypass(res, jType);
    }

    public static Map<String, Double> getTooltipData(ResourceLocation res, JType jType, Entity entity) {
        if (TooltipSupplier.tooltipExists(res, jType)) {
            HashMap<String, Double> suppliedData = new HashMap<String, Double>();
            ArrayList<Map> rawData = new ArrayList<Map>();
            for (Function func : entityTooltips.get((Object)jType).get((Object)res)) {
                rawData.add((Map)func.apply(entity));
            }
            for (int i = 0; i < rawData.size(); ++i) {
                for (Map.Entry entry : ((Map)rawData.get(i)).entrySet()) {
                    suppliedData.merge((String)entry.getKey(), (Double)entry.getValue(), (o, n) -> o > n ? o : n);
                }
            }
            return suppliedData;
        }
        return XP.getXpBypass(res, jType);
    }
}

