/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.party.PartyPendingSystem;
import harmonised.pmmo.util.XP;
import java.util.UUID;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InvitePartyCommand {
    public static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandRuntimeException {
        ServerPlayer targetPlayer;
        Player player = (Player)((CommandSourceStack)context.getSource()).m_81373_();
        UUID uuid = player.m_142081_();
        try {
            targetPlayer = EntityArgument.m_91474_(context, (String)"target");
        }
        catch (CommandSyntaxException err) {
            LOGGER.error("PMMO Invite Party Command Error: Target player does not exist. How..?");
            return 1;
        }
        int result = PartyPendingSystem.createInvitation(targetPlayer, uuid);
        switch (result) {
            case -4: {
                player.m_5661_((Component)new TranslatableComponent("pmmo.yourPartyIsFull").m_6270_(XP.textStyle.get("red")), false);
                break;
            }
            case -3: {
                player.m_5661_((Component)new TranslatableComponent("pmmo.youAlreadyInvitedPlayerToYourParty", new Object[]{targetPlayer.m_5446_()}).m_6270_(XP.textStyle.get("red")), false);
                break;
            }
            case -2: {
                player.m_5661_((Component)new TranslatableComponent("pmmo.playerAlreadyInAParty").m_6270_(XP.textStyle.get("red")), false);
                break;
            }
            case -1: {
                player.m_5661_((Component)new TranslatableComponent("pmmo.youAreNotInAParty").m_6270_(XP.textStyle.get("red")), false);
                break;
            }
            case 0: {
                player.m_5661_((Component)new TranslatableComponent("pmmo.youHaveInvitedAPlayerToYourParty", new Object[]{targetPlayer.m_5446_()}).m_6270_(XP.textStyle.get("yellow")), false);
                targetPlayer.m_5661_((Component)new TranslatableComponent("pmmo.playerInvitedYouToAParty", new Object[]{player.m_5446_()}).m_6270_(XP.textStyle.get("yellow")), false);
            }
        }
        return 1;
    }
}

