/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.util.XP;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NearbyPowerLevelCommand {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandRuntimeException {
        String[] args = context.getInput().split(" ");
        ServerPlayer sender = null;
        ServerPlayer target = null;
        try {
            sender = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (args.length > 3) {
            try {
                target = EntityArgument.m_91474_(context, (String)"target");
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        if (sender == null && target == null) {
            LOGGER.error("PMMO NearbyPowerLevel Command: Sender not player, and target is invalid!");
        } else {
            if (target == null) {
                target = sender;
            }
            double totalPowerLevel = 0.0;
            for (Player player : XP.getNearbyPlayers((Entity)target)) {
                totalPowerLevel += (double)XP.getPowerLevel(player.m_142081_());
            }
            LOGGER.info("PMMO NearbyPowerLevel Command Output: " + totalPowerLevel);
            if (sender != null) {
                sender.m_5661_((Component)new TextComponent(totalPowerLevel + " " + new TranslatableComponent("pmmo.power").getString()), false);
            }
        }
        return 1;
    }
}

