/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config;

import com.google.common.collect.Multimap;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.OreBlock;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoValues {
    public static final Logger LOGGER = LogManager.getLogger();
    private static boolean outputToConsole = Config.forgeConfig.outputAllAutoValuesToLog.get();
    public static Set<Item> itemsWithCookRecipe = new HashSet<Item>();
    public static Set<Item> itemsWithCraftRecipe = new HashSet<Item>();
    public static Set<Item> itemsWithBlastRecipe = new HashSet<Item>();
    public static Map<Item, Set<Item>> cooksFrom = new HashMap<Item, Set<Item>>();

    private static void addJsonConfigValue(String resLoc, JType jType, Map<String, Double> values, boolean fillIfExists) {
        boolean hadEntry = JsonConfig.localData.get((Object)jType).containsKey(resLoc);
        if (!hadEntry) {
            JsonConfig.localData.get((Object)jType).put(resLoc, new HashMap());
        }
        if (!hadEntry || fillIfExists) {
            for (Map.Entry<String, Double> entry : values.entrySet()) {
                double value = entry.getValue();
                if (JsonConfig.levelJTypes.contains((Object)jType)) {
                    value = Math.max(1.0, Math.min((double)Config.forgeConfig.maxLevel.get().intValue(), value));
                }
                if (!JsonConfig.localData.get((Object)jType).get(resLoc).containsKey(entry.getKey())) {
                    JsonConfig.localData.get((Object)jType).get(resLoc).put(entry.getKey(), value);
                }
                if (!outputToConsole) continue;
                StringBuilder addDataString = new StringBuilder("addData(\"" + jType.toString().toLowerCase() + "\",\t\"" + resLoc + "\", { ");
                boolean firstEntry = true;
                for (Map.Entry<String, Double> jsonEntry : values.entrySet()) {
                    if (!firstEntry) {
                        addDataString.append(", ");
                    } else {
                        firstEntry = false;
                    }
                    addDataString.append("\"").append(jsonEntry.getKey()).append("\": ").append(jsonEntry.getValue());
                }
                addDataString.append(" });");
                LOGGER.info(addDataString.toString());
            }
            if (JsonConfig.localData.get((Object)jType).get(resLoc).size() == 0) {
                JsonConfig.localData.get((Object)jType).remove(resLoc);
            }
        }
    }

    private static Map<Attribute, AttributeModifier> mergeMultimaps(Multimap<Attribute, AttributeModifier> ... maps) {
        HashMap<Attribute, AttributeModifier> output = new HashMap<Attribute, AttributeModifier>();
        for (Multimap<Attribute, AttributeModifier> map : maps) {
            for (Map.Entry entry : map.entries()) {
                output.put((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
            }
        }
        return output;
    }

    public static double getWearReqFromStack(ItemStack itemStack) {
        Multimap headHandAttributes = itemStack.m_41638_(EquipmentSlot.HEAD);
        Multimap chestHandAttributes = itemStack.m_41638_(EquipmentSlot.CHEST);
        Multimap legsHandAttributes = itemStack.m_41638_(EquipmentSlot.LEGS);
        Multimap feetHandAttributes = itemStack.m_41638_(EquipmentSlot.FEET);
        Map<Attribute, AttributeModifier> attributes = AutoValues.mergeMultimaps(headHandAttributes, chestHandAttributes, legsHandAttributes, feetHandAttributes);
        AttributeModifier armorAttribute = attributes.get(Attributes.f_22284_);
        AttributeModifier armorToughnessAttribute = attributes.get(Attributes.f_22285_);
        double armor = armorAttribute == null ? 0.0 : armorAttribute.m_22218_();
        double armorToughness = armorToughnessAttribute == null ? 0.0 : armorToughnessAttribute.m_22218_();
        ResourceLocation regKey = itemStack.m_41720_().getRegistryName();
        double wearReqOffset = regKey == null ? 0.0 : XP.getJsonMap(regKey.toString(), JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWear", 0.0);
        double wearReq = Math.min((double)Config.forgeConfig.maxLevel.get().intValue(), Math.ceil(armor * Config.forgeConfig.armorReqScale.get() + armorToughness * Config.forgeConfig.armorToughnessReqScale.get() + wearReqOffset));
        if (Config.forgeConfig.autoGenerateRoundedValuesOnly.get().booleanValue()) {
            wearReq = Math.ceil(wearReq);
        }
        if (wearReq > 1.0) {
            wearReq += Config.getConfig("autoGenerateWearReqOffset");
        }
        return Math.max(0.0, wearReq);
    }

    public static double getWeaponReqFromStack(ItemStack itemStack) {
        Multimap mainHandAttributes = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        Multimap offHandAttributes = itemStack.m_41638_(EquipmentSlot.OFFHAND);
        Map<Attribute, AttributeModifier> attributes = AutoValues.mergeMultimaps(mainHandAttributes, offHandAttributes);
        AttributeModifier attackSpeedAttribute = attributes.get(Attributes.f_22283_);
        AttributeModifier attackDamageAttribute = attributes.get(Attributes.f_22281_);
        double attackSpeed = attackSpeedAttribute == null ? 0.0 : attackSpeedAttribute.m_22218_();
        double attackDamage = attackDamageAttribute == null ? 0.0 : attackDamageAttribute.m_22218_();
        ResourceLocation regKey = itemStack.m_41720_().getRegistryName();
        double weaponReqOffset = regKey == null ? 0.0 : XP.getJsonMap(regKey.toString(), JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWeapon", 0.0);
        double weaponReq = Math.min(XP.getMaxLevel(), Math.ceil(attackDamage * Config.forgeConfig.attackDamageReqScale.get() * (4.0 + attackSpeed) + weaponReqOffset));
        if (Config.forgeConfig.autoGenerateRoundedValuesOnly.get().booleanValue()) {
            weaponReq = Math.ceil(weaponReq);
        }
        if (weaponReq > 0.0) {
            weaponReq += Config.getConfig("autoGenerateWeaponReqOffset");
        }
        return Math.max(0.0, weaponReq);
    }

    public static Map<String, Double> getToolReqFromStack(ItemStack itemStack) {
        HashMap<String, Double> reqTool = new HashMap<String, Double>();
        ResourceLocation regKey = itemStack.m_41720_().getRegistryName();
        double toolReqOffset = regKey == null ? 0.0 : XP.getJsonMap(regKey.toString(), JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetTool", 0.0);
        double speed = itemStack.m_41691_(Blocks.f_49999_.m_49966_());
        double toolReq = Math.max(1.0, Math.min((double)Config.forgeConfig.maxLevel.get().intValue(), speed * Config.forgeConfig.toolReqScaleLog.get() + toolReqOffset));
        if (toolReq > 5.0) {
            reqTool.put(Skill.WOODCUTTING.toString(), toolReq);
        }
        speed = itemStack.m_41691_(Blocks.f_50069_.m_49966_());
        toolReq = Math.max(1.0, Math.min((double)Config.forgeConfig.maxLevel.get().intValue(), speed * Config.forgeConfig.toolReqScaleOre.get() + toolReqOffset));
        if (toolReq > 5.0) {
            reqTool.put(Skill.MINING.toString(), toolReq);
        }
        speed = itemStack.m_41691_(Blocks.f_50493_.m_49966_());
        toolReq = Math.max(1.0, Math.min((double)Config.forgeConfig.maxLevel.get().intValue(), speed * Config.forgeConfig.toolReqScaleDirt.get() + toolReqOffset));
        if (toolReq > 5.0) {
            reqTool.put(Skill.EXCAVATION.toString(), toolReq);
        }
        if (Config.forgeConfig.autoGenerateRoundedValuesOnly.get().booleanValue()) {
            XP.ceilMapAnyDouble(reqTool);
        }
        for (String skill : reqTool.keySet()) {
            double level = (Double)reqTool.get(skill);
            if (!(level > 1.0)) continue;
            reqTool.replace(skill, Math.max(0.0, level + Config.getConfig("autoGenerateToolReqOffset")));
        }
        return reqTool;
    }

    public static String getItemSpecificSkillOrDefault(String resLoc, String defaultSkill) {
        String skill = AutoValues.getItemSpecificSkill(resLoc);
        return skill == null ? defaultSkill : skill;
    }

    public static String getItemSpecificSkill(String resLoc) {
        Map itemSpecificMap = JsonConfig.data.get((Object)JType.ITEM_SPECIFIC).getOrDefault(resLoc.toString(), new HashMap());
        String skill = null;
        if (itemSpecificMap.getOrDefault("archeryWeapon", 0.0) != 0.0) {
            skill = Skill.ARCHERY.toString();
        } else if (itemSpecificMap.getOrDefault("magicWeapon", 0.0) != 0.0) {
            skill = Skill.MAGIC.toString();
        } else if (itemSpecificMap.getOrDefault("magicWeapon", 0.0) != 0.0) {
            skill = Skill.COMBAT.toString();
        } else if (itemSpecificMap.getOrDefault("gunWeapon", 0.0) != 0.0) {
            skill = Skill.GUNSLINGING.toString();
        }
        return skill;
    }

    public static void setAutoValues() {
        if (Config.forgeConfig.autoGenerateValuesEnabled.get().booleanValue()) {
            Collection allRecipes = PmmoSavedData.getServer().m_129894_().m_44051_();
            itemsWithCookRecipe.clear();
            itemsWithCraftRecipe.clear();
            itemsWithBlastRecipe.clear();
            for (Recipe recipe : allRecipes) {
                if (recipe == null || recipe.m_8043_() == null) continue;
                Item item = recipe.m_8043_().m_41720_();
                if (recipe.m_6671_() == RecipeType.f_44107_) {
                    itemsWithCraftRecipe.add(item);
                    continue;
                }
                if (recipe.m_6671_() != RecipeType.f_44110_) continue;
                Item outputItem = recipe.m_8043_().m_41720_();
                itemsWithCookRecipe.add(outputItem);
                for (Ingredient ingredient : recipe.m_7527_()) {
                    for (ItemStack itemStack : ingredient.m_43908_()) {
                        if (!cooksFrom.containsKey(outputItem)) {
                            cooksFrom.put(outputItem, new HashSet());
                        }
                        cooksFrom.get(outputItem).add(itemStack.m_41720_());
                    }
                }
            }
            for (Item item : ForgeRegistries.ITEMS) {
                try {
                    FoodProperties food;
                    ItemStack itemStack = new ItemStack((ItemLike)item);
                    String resLoc = item.getRegistryName().toString();
                    String wearReqSkill = Config.forgeConfig.autoGenerateWearReqAsCombat.get() != false ? Skill.COMBAT.toString() : Skill.ENDURANCE.toString();
                    double enduranceReq = AutoValues.getWearReqFromStack(itemStack) + XP.getJsonMap(resLoc, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWear", 0.0);
                    double combatReq = AutoValues.getWeaponReqFromStack(itemStack) + XP.getJsonMap(resLoc, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWeapon", 0.0);
                    Map<String, Double> reqTool = AutoValues.getToolReqFromStack(itemStack);
                    if (enduranceReq > 1.0 && Config.forgeConfig.wearReqEnabled.get().booleanValue() && Config.forgeConfig.autoGenerateWearReqEnabled.get().booleanValue()) {
                        HashMap<String, Double> reqWear = new HashMap<String, Double>();
                        reqWear.put(wearReqSkill, Math.max(1.0, enduranceReq));
                        AutoValues.addJsonConfigValue(resLoc, JType.REQ_WEAR, reqWear, false);
                    }
                    if (combatReq > 1.0 && Config.forgeConfig.weaponReqEnabled.get().booleanValue() && Config.forgeConfig.autoGenerateWeaponReqEnabled.get().booleanValue()) {
                        HashMap<String, Double> reqWeapon = new HashMap<String, Double>();
                        reqWeapon.put(AutoValues.getItemSpecificSkillOrDefault(item.getRegistryName().toString(), Skill.COMBAT.toString()), Math.max(1.0, combatReq));
                        AutoValues.addJsonConfigValue(resLoc, JType.REQ_WEAPON, reqWeapon, false);
                    }
                    if (reqTool.size() > 0 && Config.forgeConfig.toolReqEnabled.get().booleanValue() && Config.forgeConfig.autoGenerateToolReqEnabled.get().booleanValue()) {
                        AutoValues.addJsonConfigValue(resLoc, JType.REQ_TOOL, reqTool, true);
                    }
                    if (Config.forgeConfig.autoGenerateCraftingXpEnabled.get().booleanValue()) {
                        float healing;
                        float saturation;
                        FoodProperties food2;
                        double highestToolReq = reqTool.values().stream().reduce(Math::max).orElse(0.0);
                        double craftingXp = 0.0;
                        double smithingXp = 0.0;
                        double cookingXp = 0.0;
                        if (enduranceReq > 0.0 || combatReq > 0.0 || highestToolReq > 0.0) {
                            craftingXp = enduranceReq * 10.0 + Math.max(Math.max(combatReq - 10.0, 1.0) * 5.0, Math.max(highestToolReq - 10.0, 1.0) * 5.0);
                            smithingXp = Math.max(enduranceReq - 10.0, 1.0) * 5.0 + Math.max(Math.max(combatReq - 20.0, 1.0) * 2.0, Math.max(highestToolReq - 20.0, 1.0) * 2.0);
                            craftingXp *= Config.forgeConfig.autoGeneratedCraftingXpValueMultiplierCrafting.get().doubleValue();
                            smithingXp *= Config.forgeConfig.autoGeneratedCraftingXpValueMultiplierSmithing.get().doubleValue();
                        }
                        HashMap<String, Double> xpValueMap = new HashMap<String, Double>();
                        if (item.m_41472_() && (food2 = item.m_41473_()) != null && (cookingXp = (double)((saturation = food2.m_38745_()) * 15.0f + (healing = (float)food2.m_38744_()))) > 0.0) {
                            cookingXp *= Config.forgeConfig.autoGeneratedCraftingXpValueMultiplierCooking.get().doubleValue();
                        }
                        if (craftingXp > 0.0) {
                            xpValueMap.put(Skill.CRAFTING.toString(), craftingXp);
                        }
                        if (smithingXp > 0.0) {
                            xpValueMap.put(Skill.SMITHING.toString(), smithingXp);
                        }
                        if (cookingXp > 0.0 && itemsWithCraftRecipe.contains(item)) {
                            xpValueMap.put(Skill.COOKING.toString(), cookingXp);
                        }
                        AutoValues.addJsonConfigValue(resLoc, JType.XP_VALUE_CRAFT, xpValueMap, true);
                    }
                    if (!Config.forgeConfig.autoGenerateCookingXpEnabled.get().booleanValue() && !Config.forgeConfig.autoGenerateCookingExtraChanceEnabled.get().booleanValue() || !itemsWithCookRecipe.contains(item)) continue;
                    double cookingXp = 0.0;
                    if (!item.m_41472_() || (food = item.m_41473_()) == null) continue;
                    float saturation = food.m_38745_();
                    float healing = food.m_38744_();
                    cookingXp = saturation * 15.0f + healing;
                    if (!((cookingXp *= Config.forgeConfig.autoGeneratedCraftingXpValueMultiplierCooking.get().doubleValue()) > 0.0)) continue;
                    HashMap<String, Double> xpValueMap = new HashMap<String, Double>();
                    xpValueMap.put(Skill.COOKING.toString(), cookingXp);
                    for (Item rawItem : cooksFrom.get(item)) {
                        String rawResLoc = rawItem.getRegistryName().toString();
                        if (Config.forgeConfig.autoGenerateCookingXpEnabled.get().booleanValue()) {
                            AutoValues.addJsonConfigValue(rawResLoc, JType.XP_VALUE_COOK, xpValueMap, true);
                        }
                        if (!Config.forgeConfig.autoGenerateCookingExtraChanceEnabled.get().booleanValue()) continue;
                        HashMap<String, Double> extraChanceMap = new HashMap<String, Double>();
                        extraChanceMap.put("extraChance", 10.0 / (double)(saturation * 15.0f + healing));
                        AutoValues.addJsonConfigValue(rawResLoc, JType.INFO_COOK, extraChanceMap, true);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug((Object)e);
                }
            }
            if (Config.forgeConfig.autoGenerateExtraChanceEnabled.get().booleanValue()) {
                for (Block block : ForgeRegistries.BLOCKS) {
                    try {
                        String resLoc = block.getRegistryName().toString();
                        JType jType = JType.NONE;
                        HashMap<String, Double> infoMap = new HashMap<String, Double>();
                        double chance = 0.0;
                        Set tags = block.getTags();
                        if (block instanceof OreBlock || tags.contains(new ResourceLocation("forge:ores"))) {
                            jType = JType.INFO_ORE;
                            chance = Config.forgeConfig.defaultExtraChanceOre.get();
                        } else if (block instanceof CropBlock || tags.contains(new ResourceLocation("minecraft:crops"))) {
                            jType = JType.INFO_PLANT;
                            chance = Config.forgeConfig.defaultExtraChancePlant.get();
                        } else if (tags.contains(new ResourceLocation("minecraft:logs"))) {
                            jType = JType.INFO_LOG;
                            chance = Config.forgeConfig.defaultExtraChanceLog.get();
                        }
                        if (!jType.equals((Object)JType.NONE)) {
                            infoMap.put("extraChance", chance);
                        }
                        if (infoMap.size() <= 0 || !(infoMap.getOrDefault("extraChance", 0.0) > 0.0)) continue;
                        AutoValues.addJsonConfigValue(resLoc, jType, infoMap, false);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                }
            }
            JsonConfig.data = JsonConfig.localData;
        }
    }
}

