/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;

public class BreedHandler {
    public static void handleBreedEvent(BabyEntitySpawnEvent event) {
        if (event.getChild() != null && event.getCausedByPlayer() != null && event.getCausedByPlayer() instanceof ServerPlayer && !(event.getCausedByPlayer() instanceof FakePlayer)) {
            ServerPlayer causedByPlayer = (ServerPlayer)event.getCausedByPlayer();
            double defaultBreedingXp = Config.forgeConfig.defaultBreedingXp.get();
            String regKey = event.getChild().m_20078_();
            Vec3 midPos = Util.getMidVec(event.getParentA().m_20182_(), event.getParentB().m_20182_());
            Vec3 xpDropPos = new Vec3(midPos.m_7096_(), midPos.m_7098_() + (double)event.getChild().m_20192_() + 0.523, midPos.m_7094_());
            Map<String, Double> award = XP.getXp((Entity)event.getChild(), JType.XP_VALUE_BREED);
            if (award.size() == 0) {
                award.put(Skill.FARMING.toString(), defaultBreedingXp);
            }
            if (XP.isHoldingDebugItemInOffhand((Player)causedByPlayer)) {
                causedByPlayer.m_5661_((Component)new TextComponent(regKey), false);
            }
            for (String awardSkillName : award.keySet()) {
                WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)causedByPlayer.m_183503_()), xpDropPos.m_7096_(), xpDropPos.m_7098_(), xpDropPos.m_7094_(), 0.5, award.get(awardSkillName), awardSkillName);
                XP.addWorldXpDrop(xpDrop, causedByPlayer);
                Skill.addXp(awardSkillName, causedByPlayer, (double)award.get(awardSkillName), "breeding " + regKey, false, false);
            }
        }
    }
}

