/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;

public class GrowHandler {
    public static void handleSaplingGrow(SaplingGrowTreeEvent event) {
        Level world = (Level)event.getWorld();
        BlockPos pos = event.getPos();
        ResourceLocation dimResLoc = XP.getDimResLoc(world);
        UUID uuid = ChunkDataHandler.checkPos(dimResLoc, pos);
        ChunkDataHandler.delPos(dimResLoc, pos);
        if (uuid != null) {
            ResourceLocation resLoc = event.getWorld().m_8055_(pos).m_60734_().getRegistryName();
            Map<String, Double> award = XP.getXpBypass(resLoc, JType.XP_VALUE_GROW);
            if (award.size() == 0) {
                award.put(Skill.FARMING.toString(), Config.forgeConfig.defaultSaplingGrowXp.get());
            }
            for (String awardSkillName : award.keySet()) {
                WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 3.046, (double)pos.m_123343_() + 0.5, 1.5, award.get(awardSkillName), awardSkillName);
                xpDrop.setDecaySpeed(0.1);
                XP.addWorldXpDrop(xpDrop, uuid);
                Skill.addXp(awardSkillName, uuid, (double)award.get(awardSkillName), "Growing " + resLoc + " at " + pos, false, false);
            }
        }
    }

    public static void handleCropGrow(BlockEvent.CropGrowEvent.Post event) {
        Level world = (Level)event.getWorld();
        BlockPos pos = event.getPos();
        ResourceLocation resLoc = event.getWorld().m_8055_(pos).m_60734_().getRegistryName();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        UUID uuid = ChunkDataHandler.checkPos(world, pos);
        if (uuid == null && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).containsKey(resLoc.toString()) && JsonConfig.data.get((Object)JType.BLOCK_SPECIFIC).get(resLoc.toString()).containsKey("growsUpwards")) {
            BlockPos tempPos = pos;
            while (world.m_8055_(tempPos.m_7495_()).m_60734_().equals(block) && uuid == null) {
                tempPos = tempPos.m_7495_();
                uuid = ChunkDataHandler.checkPos(world, tempPos);
            }
        }
        if (uuid != null) {
            int maxAge = -1;
            IntegerProperty ageProp = null;
            if (state.m_61138_((Property)BlockStateProperties.f_61405_)) {
                ageProp = BlockStateProperties.f_61405_;
                maxAge = 1;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61406_)) {
                ageProp = BlockStateProperties.f_61406_;
                maxAge = 2;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61407_)) {
                ageProp = BlockStateProperties.f_61407_;
                maxAge = 3;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61408_)) {
                ageProp = BlockStateProperties.f_61408_;
                maxAge = 5;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61409_)) {
                ageProp = BlockStateProperties.f_61409_;
                maxAge = 7;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61410_)) {
                ageProp = BlockStateProperties.f_61410_;
                maxAge = 15;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61411_)) {
                ageProp = BlockStateProperties.f_61411_;
                maxAge = 25;
            } else if (state.m_61138_((Property)BlockStateProperties.f_61425_)) {
                ageProp = BlockStateProperties.f_61425_;
                maxAge = 4;
            }
            if (ageProp == null) {
                return;
            }
            int age = (Integer)state.m_61143_((Property)ageProp);
            int bonusGrowth = 0;
            if (age < maxAge) {
                double growthRateBonus = Config.forgeConfig.growthSpeedIncreasePerLevel.get() * (double)Skill.getLevel(Skill.FARMING.toString(), uuid);
                bonusGrowth = (int)growthRateBonus;
                growthRateBonus %= 1.0;
                if (Math.random() < growthRateBonus) {
                    ++bonusGrowth;
                }
                if (bonusGrowth > 0) {
                    age = Math.min(age + bonusGrowth, maxAge);
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)ageProp, (Comparable)Integer.valueOf(age)));
                }
            }
            if (age == maxAge) {
                Map<String, Double> award = XP.getXpBypass(resLoc, JType.XP_VALUE_GROW);
                if (award.size() == 0) {
                    award.put(Skill.FARMING.toString(), Config.forgeConfig.defaultCropGrowXp.get());
                }
                for (String awardSkillName : award.keySet()) {
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.523, (double)pos.m_123343_() + 0.5, 0.5, award.get(awardSkillName), awardSkillName);
                    xpDrop.setDecaySpeed(0.1);
                    XP.addWorldXpDrop(xpDrop, uuid);
                    Skill.addXp(awardSkillName, uuid, (double)award.get(awardSkillName), "Growing " + resLoc + " at " + pos, false, false);
                }
            }
        }
    }
}

