/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.ProjectMMOMod;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.network.WebHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerConnectedHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static List<UUID> lavenderPatreons = new ArrayList<UUID>(){
        {
            this.add(UUID.fromString("12319dec-8880-4e9b-8ddb-01719a66e793"));
            this.add(UUID.fromString("6aefd519-8f6b-4c3a-bb1b-aac88a8dd57e"));
        }
    };
    public static List<UUID> fieryPatreons = new ArrayList<UUID>(){};
    public static List<UUID> lapisPatreons = new ArrayList<UUID>(){
        {
            this.add(UUID.fromString("e4c7e475-c1ff-4f94-956c-ac5be02ce04a"));
        }
    };
    public static List<UUID> dandelionPatreons = new ArrayList<UUID>(){
        {
            this.add(UUID.fromString("8eb0578d-c113-49d3-abf6-a6d36f6d1116"));
            this.add(UUID.fromString("554b53b8-d0fa-409e-ab87-2a34bf83e506"));
            this.add(UUID.fromString("2ea5efa1-756b-4c9e-9605-7f53830d6cfa"));
            this.add(UUID.fromString("21bb554a-f339-48ef-80f7-9a5083172892"));
        }
    };
    public static List<UUID> ironPatreons = new ArrayList<UUID>(){
        {
            this.add(UUID.fromString("0bc51f06-9906-41ea-9fb4-7e9be169c980"));
            this.add(UUID.fromString("5bfdb948-7b66-476a-aefe-d45e4778fb2d"));
            this.add(UUID.fromString("edafb5eb-9ccb-4121-bef7-e7ffded64ee3"));
            this.add(UUID.fromString("8d2460f3-c840-4b8e-a2d2-f7d5168cbdeb"));
        }
    };
    public static Set<UUID> muteList = new HashSet<UUID>(){
        {
            this.add(UUID.fromString("21bb554a-f339-48ef-80f7-9a5083172892"));
        }
    };

    public static void handlePlayerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!player.f_19853_.m_5776_()) {
            UUID uuid = player.m_142081_();
            boolean showWelcome = Config.forgeConfig.showWelcome.get();
            boolean showPatreonWelcome = Config.forgeConfig.showPatreonWelcome.get();
            PmmoSavedData.get().setName(player.m_5446_().getString(), uuid);
            PlayerConnectedHandler.migratePlayerDataToWorldSavedData(player);
            XP.syncPlayer(player);
            PlayerConnectedHandler.awardScheduledXp(uuid);
            if (Config.forgeConfig.warnOutdatedVersion.get().booleanValue() && ProjectMMOMod.isVersionBehind()) {
                Style style = XP.getColorStyle(0xAA3333).setUnderlined(Boolean.valueOf(true));
                String updateMsg = WebHandler.getLatestMessage();
                if (updateMsg != null) {
                    style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(updateMsg)));
                }
                TranslatableComponent textComp = new TranslatableComponent("pmmo.outdatedVersion", new Object[]{WebHandler.getLatestVersion(), ProjectMMOMod.getCurrentVersion()});
                textComp.m_6270_(style);
                player.m_5661_((Component)textComp, false);
            }
            if (!muteList.contains(uuid)) {
                if (lapisPatreons.contains(uuid)) {
                    player.m_20194_().m_6846_().m_11314_().forEach(thePlayer -> thePlayer.m_5661_((Component)new TranslatableComponent("pmmo.lapisPatreonWelcome", new Object[]{thePlayer.m_5446_().getString()}).m_6270_(XP.textStyle.get("cyan")), false));
                } else if (showPatreonWelcome) {
                    if (dandelionPatreons.contains(uuid)) {
                        player.m_5661_((Component)new TranslatableComponent("pmmo.dandelionPatreonWelcome", new Object[]{player.m_5446_().getString()}).m_6270_(XP.textStyle.get("yellow")), false);
                    } else if (ironPatreons.contains(uuid)) {
                        player.m_5661_((Component)new TranslatableComponent("pmmo.ironPatreonWelcome", new Object[]{player.m_5446_().getString()}).m_6270_(XP.textStyle.get("grey")), false);
                    }
                }
                if (showWelcome) {
                    player.m_5661_((Component)new TranslatableComponent("pmmo.welcomeText", new Object[]{new TranslatableComponent("pmmo.clickMe").m_6270_(XP.getColorStyle(0xFF00FF).setUnderlined(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pmmo help")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("pmmo.openInfo"))))}), false);
                }
            }
        } else {
            ClientHandler.hiscoreMap = new HashMap<String, Map<String, Map<String, Double>>>();
        }
    }

    private static void migratePlayerDataToWorldSavedData(Player player) {
        if (player.getPersistentData().m_128441_("pmmo")) {
            Map<String, Double> map;
            CompoundTag tag;
            CompoundTag pmmoTag = player.getPersistentData().m_128469_("pmmo");
            UUID uuid = player.m_142081_();
            LOGGER.info("Migrating Player " + player.m_5446_().getString() + " Pmmo Data from PlayerData to WorldSavedData");
            if (pmmoTag.m_128441_("skills")) {
                tag = pmmoTag.m_128469_("skills");
                for (String key : tag.m_128431_()) {
                    Skill.setXp(key, uuid, Skill.getXp(key, uuid) + tag.m_128459_(key));
                    LOGGER.info("Adding " + tag.m_128459_(key) + " xp in " + key);
                }
            }
            if (pmmoTag.m_128441_("preferences")) {
                tag = pmmoTag.m_128469_("preferences");
                map = Config.getPreferencesMap(player);
                for (String key : tag.m_128431_()) {
                    map.put(key, tag.m_128459_(key));
                }
            }
            if (pmmoTag.m_128441_("abilities")) {
                tag = pmmoTag.m_128469_("abilities");
                map = Config.getAbilitiesMap(player);
                for (String key : tag.m_128431_()) {
                    map.put(key, tag.m_128459_(key));
                }
            }
            player.getPersistentData().m_128473_("pmmo");
            LOGGER.info("Migrated Player " + player.m_5446_().getString() + " Done");
            PmmoSavedData.get().m_77760_(true);
        }
    }

    private static void awardScheduledXp(UUID uuid) {
        Map<String, Double> scheduledXp = PmmoSavedData.get().getScheduledXpMap(uuid);
        if (scheduledXp.size() > 0) {
            LOGGER.info("Awarding Scheduled Xp for: " + PmmoSavedData.get().getName(uuid));
        }
        for (Map.Entry<String, Double> entry : scheduledXp.entrySet()) {
            Skill.addXp(entry.getKey(), uuid, (double)entry.getValue(), "scheduledXp", false, false);
            LOGGER.info("+" + entry.getValue() + " in " + entry.getKey().toString());
        }
        PmmoSavedData.get().removeScheduledXpUuid(uuid);
    }
}

