/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.perks.PerkRegistry;
import harmonised.pmmo.api.perks.PerkTrigger;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.ScreenshotHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.party.PartyPendingSystem;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.CheeseTracker;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class PlayerTickHandler {
    private static final Map<UUID, Long> lastAward = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> lastVeinAward = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> lastCheeseUpdate = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> hpRegen = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> sync = new HashMap<UUID, Long>();
    private static final Map<UUID, Integer> sneakCounter = new HashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> sneakTracker = new HashMap<UUID, Boolean>();
    public static boolean syncPrefs = false;

    public static void handlePlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.f_19853_.f_46443_ && XP.isPlayerSurvival(event.player) && event.player.m_6084_()) {
            double gap;
            ServerPlayer player = (ServerPlayer)event.player;
            UUID uuid = player.m_142081_();
            if (player.m_20142_()) {
                PerkRegistry.executePerk(PerkTrigger.SPRINTING, player);
            } else {
                PerkRegistry.terminatePerk(PerkTrigger.SPRINTING, player);
            }
            if (player.m_6069_()) {
                PerkRegistry.executePerk(PerkTrigger.SUBMERGED, player);
            } else {
                PerkRegistry.terminatePerk(PerkTrigger.SUBMERGED, player);
            }
            CompoundTag dataIn = new CompoundTag();
            dataIn.m_128350_("healthIn", player.m_21223_());
            PerkRegistry.executePerk(PerkTrigger.HEALTH_LEVEL, player, dataIn);
            if (!player.f_19853_.f_46443_ && player.f_19853_.m_142572_().m_129921_() % 200 == 200) {
                WorldTickHandler.updateVein((Player)player, 0.0);
            }
            if (!lastAward.containsKey(uuid)) {
                lastAward.put(uuid, System.nanoTime());
            }
            if (!lastVeinAward.containsKey(uuid)) {
                lastVeinAward.put(uuid, System.nanoTime());
            }
            if (!lastCheeseUpdate.containsKey(uuid)) {
                lastCheeseUpdate.put(uuid, System.nanoTime());
            }
            if (!hpRegen.containsKey(uuid)) {
                hpRegen.put(uuid, System.nanoTime());
            }
            if (!sync.containsKey(uuid)) {
                sync.put(uuid, System.nanoTime());
            }
            if (!sneakCounter.containsKey(uuid)) {
                sneakTracker.put(uuid, player.m_6144_());
                sneakCounter.put(uuid, sneakTracker.get(uuid) != false ? 1 : 0);
            }
            int sneakCount = sneakCounter.get(uuid);
            if (player.m_6144_() && !sneakTracker.get(uuid).booleanValue()) {
                ++sneakCount;
                if (!player.f_19853_.f_46443_) {
                    double award;
                    double roll = Math.random();
                    double chance = 0.01 * (double)(sneakCount - 250) / 5.0;
                    if (sneakCount > 250 && roll < chance) {
                        player.m_6469_(DamageSource.f_19320_, (float)Math.max(1.0, chance * 2.5));
                        System.out.println(chance);
                        if (player.m_21223_() <= 0.0f) {
                            sneakCount = 0;
                        }
                    }
                    if (sneakCount > 50 && (award = (double)(sneakCount - 50) / 200.0) > 0.0) {
                        XP.awardXp(player, Skill.ENDURANCE.toString(), "twerking", award, true, false, false);
                    }
                }
            }
            sneakCounter.put(uuid, sneakCount);
            sneakTracker.put(uuid, player.m_6144_());
            double veinGap = (double)(System.nanoTime() - lastVeinAward.get(uuid)) / 1.0E9;
            double cheeseGap = (double)(System.nanoTime() - lastCheeseUpdate.get(uuid)) / 1.0E9;
            double hpRegenGap = (double)(System.nanoTime() - hpRegen.get(uuid)) / 1.0E9;
            double syncGap = (double)(System.nanoTime() - sync.get(uuid)) / 1.0E9;
            if (veinGap > 0.25) {
                sneakCounter.put(uuid, Math.max(0, sneakCount - 1));
                WorldTickHandler.updateVein((Player)player, veinGap);
                lastVeinAward.put(uuid, System.nanoTime());
                if (Config.forgeConfig.antiCheeseEnabled.get().booleanValue() && cheeseGap > Config.forgeConfig.cheeseCheckFrequency.get()) {
                    CheeseTracker.trackCheese(player);
                    lastCheeseUpdate.put(uuid, System.nanoTime());
                }
                if (hpRegenGap > PlayerTickHandler.getHpRegenTime((Player)player)) {
                    float startHp = player.m_21223_();
                    player.m_5634_(1.0f);
                    XP.awardXp(player, Skill.ENDURANCE.toString(), "Regeneration", 60.0 / PlayerTickHandler.getHpRegenTime((Player)player) * Config.forgeConfig.hpRegenXpMultiplier.get() * (double)(player.m_21223_() - startHp), true, false, false);
                    hpRegen.put(uuid, System.nanoTime());
                }
            }
            if (syncGap > 2.5) {
                PartyPendingSystem.sendPlayerOfflineData(player);
                sync.put(uuid, System.nanoTime());
            }
            if ((gap = (double)(System.nanoTime() - lastAward.get(uuid)) / 1.0E9) > 0.5) {
                WorldXpDrop xpDrop;
                int swimLevel = APIUtils.getLevel(Skill.SWIMMING.toString(), (Player)player);
                int flyLevel = APIUtils.getLevel(Skill.FLYING.toString(), (Player)player);
                int agilityLevel = APIUtils.getLevel(Skill.AGILITY.toString(), (Player)player);
                float swimAmp = EnchantmentHelper.m_44922_((LivingEntity)player);
                float speedAmp = 0.0f;
                Inventory inv = player.m_150109_();
                XP.checkBiomeLevelReq((Player)player);
                if (!inv.m_8020_(39).m_41619_()) {
                    XP.applyWornPenalty((Player)player, player.m_150109_().m_8020_(39));
                }
                if (!inv.m_8020_(38).m_41619_()) {
                    XP.applyWornPenalty((Player)player, player.m_150109_().m_8020_(38));
                }
                if (!inv.m_8020_(37).m_41619_()) {
                    XP.applyWornPenalty((Player)player, player.m_150109_().m_8020_(37));
                }
                if (!inv.m_8020_(36).m_41619_()) {
                    XP.applyWornPenalty((Player)player, player.m_150109_().m_8020_(36));
                }
                if (!player.m_21205_().m_41619_()) {
                    XP.applyEnchantmentUsePenalty((Player)player, player.m_21205_());
                }
                if (!player.m_21206_().m_41619_()) {
                    XP.applyWornPenalty((Player)player, player.m_21206_());
                    XP.applyEnchantmentUsePenalty((Player)player, player.m_21206_());
                }
                if (player.m_21023_(MobEffects.f_19596_)) {
                    speedAmp = player.m_21124_(MobEffects.f_19596_).m_19564_() + 1;
                }
                double swimAward = (3.0 + (double)swimLevel / 10.0) * gap * (1.0 + (double)swimAmp / 4.0);
                double flyAward = (1.0 + (double)flyLevel / 30.77) * gap;
                double runAward = (1.0 + (double)agilityLevel / 30.77) * gap * (1.0 + (double)speedAmp / 4.0);
                if (!player.f_19864_) {
                    swimAward *= 0.1;
                }
                lastAward.replace(uuid, System.nanoTime());
                Block waterBlock = Blocks.f_49990_;
                Block tallSeagrassBlock = Blocks.f_50038_;
                Block kelpBlock = Blocks.f_50576_;
                BlockPos playerPos = XP.vecToBlock(player.m_20182_());
                boolean waterBelow = true;
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        Block currBlock = player.m_20193_().m_8055_(playerPos.m_7495_().m_142385_(i).m_142390_(j)).m_60734_();
                        if (currBlock.equals(waterBlock) || currBlock.equals(tallSeagrassBlock) || currBlock.equals(kelpBlock)) continue;
                        waterBelow = false;
                    }
                }
                boolean waterAbove = player.m_20193_().m_8055_(playerPos.m_7494_()).m_60734_().equals(waterBlock);
                ServerLevel world = player.m_183503_();
                Vec3 xpDropPos = player.m_20182_();
                if (player.m_20142_()) {
                    if (player.m_20069_() && (waterAbove || waterBelow)) {
                        xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), xpDropPos.m_7096_(), xpDropPos.m_7098_(), xpDropPos.m_7094_(), 0.35, swimAward, Skill.SWIMMING.toString());
                        XP.addWorldXpDrop(xpDrop, player);
                        XP.awardXp(player, Skill.SWIMMING.toString(), "swimming fast", swimAward * 1.25, true, false, false);
                    } else {
                        xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), xpDropPos.m_7096_(), xpDropPos.m_7098_() + 0.523, xpDropPos.m_7094_(), 0.15, runAward, Skill.AGILITY.toString());
                        XP.addWorldXpDrop(xpDrop, player);
                        XP.awardXp(player, Skill.AGILITY.toString(), "running", runAward, true, false, false);
                    }
                }
                if (player.m_20069_() && (waterAbove || waterBelow || player.m_19941_((Tag)FluidTags.f_13131_))) {
                    if (!player.m_20142_()) {
                        xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), xpDropPos.m_7096_(), xpDropPos.m_7098_(), xpDropPos.m_7094_(), 0.35, swimAward, Skill.SWIMMING.toString());
                        XP.addWorldXpDrop(xpDrop, player);
                        XP.awardXp(player, Skill.SWIMMING.toString(), "swimming", swimAward, true, false, false);
                    }
                } else if (player.m_21255_()) {
                    xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), xpDropPos.m_7096_(), xpDropPos.m_7098_(), xpDropPos.m_7094_(), 0.35, flyAward, Skill.FLYING.toString());
                    XP.addWorldXpDrop(xpDrop, player);
                    XP.awardXp(player, Skill.FLYING.toString(), "flying", flyAward, true, false, false);
                }
                if (player.m_20202_() instanceof Boat && waterBelow) {
                    if (!player.m_20142_()) {
                        swimAward *= 1.5;
                    }
                    xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc((Level)world), xpDropPos.m_7096_(), xpDropPos.m_7098_(), xpDropPos.m_7094_(), 0.35, swimAward, Skill.SWIMMING.toString());
                    XP.addWorldXpDrop(xpDrop, player);
                    XP.awardXp(player, Skill.SAILING.toString(), "Sailing", swimAward, true, false, false);
                }
            }
        }
        if (event.player.f_19853_.f_46443_) {
            if (XPOverlayGUI.screenshots.size() > 0) {
                for (String key : new HashSet<String>(XPOverlayGUI.screenshots)) {
                    ScreenshotHandler.takeScreenshot(key, "levelup");
                    XPOverlayGUI.screenshots.remove(key);
                    XPOverlayGUI.listOn = XPOverlayGUI.listWasOn;
                }
            }
            if (syncPrefs) {
                ClientHandler.syncPrefsToServer();
                syncPrefs = false;
            }
        }
    }

    public static double getHpRegenTime(Player player) {
        double dividend = Config.getConfig("hpRegenPerMinuteBase") + (double)APIUtils.getLevel(Skill.ENDURANCE.toString(), player) * Config.getConfig("hpRegenPerMinuteBoostPerLevel");
        return dividend <= 0.0 ? Double.POSITIVE_INFINITY : 60.0 / dividend;
    }
}

