/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.ftb_quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import harmonised.pmmo.ftb_quests.FTBQHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkillTask
extends Task {
    public static TaskType SKILL = FTBQHandler.SKILL;
    public String skill = Skill.MINING.toString();
    public double requiredLevel = 1.0;

    public SkillTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return SKILL;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("skill", this.skill);
        nbt.m_128347_("requiredLevel", this.requiredLevel);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.skill = nbt.m_128461_("skill");
        this.requiredLevel = nbt.m_128459_("requiredLevel");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.skill, Short.MAX_VALUE);
        buffer.writeDouble(this.requiredLevel);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.skill = buffer.m_130136_(Short.MAX_VALUE);
        this.requiredLevel = buffer.readDouble();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("skill", (Object)this.skill, input -> {
            this.skill = (String)input;
        }, NameMap.of((Object)Skill.MINING.toString(), (Object[])Skill.getSkills().keySet().toArray()).create());
        config.addDouble("requiredLevel", this.requiredLevel, input -> {
            this.requiredLevel = input;
        }, this.requiredLevel, 1.0, XP.getMaxLevel());
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (teamData.isCompleted((QuestObject)this)) {
            return;
        }
        teamData.setProgress((Task)this, (long)Skill.getLevel(this.skill, (Player)player));
    }

    public long getMaxProgress() {
        return (long)this.requiredLevel;
    }
}

