/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import harmonised.pmmo.gui.PrefsSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class PrefsEntry
implements Widget {
    public static Font font = Minecraft.m_91087_().f_91062_;
    public PrefsSlider slider;
    public Button button;
    public EditBox textField;
    public String preference;
    public String prefix;
    public String suffix;
    public double defaultVal;
    public final int sliderWidth = 150;
    public final int height = 16;
    private final int textFieldWidth = 36;
    public final boolean isSwitch;
    public final boolean removeIfMax;

    public PrefsEntry(String preference, String prefix, String suffix, double minVal, double maxVal, double curVal, double defaultVal, boolean showDec, boolean showStr, boolean removeIfMax, boolean isSwitch) {
        this.preference = preference;
        this.prefix = prefix;
        this.suffix = suffix;
        this.isSwitch = isSwitch;
        this.removeIfMax = removeIfMax;
        if (minVal == maxVal) {
            maxVal = 1.0E-5;
        }
        if (Double.isNaN(curVal)) {
            curVal = defaultVal;
        }
        if (defaultVal > maxVal) {
            defaultVal = maxVal;
        }
        if (defaultVal < minVal) {
            defaultVal = minVal;
        }
        if (curVal > maxVal) {
            curVal = maxVal;
        }
        if (curVal < minVal) {
            curVal = minVal;
        }
        this.defaultVal = defaultVal;
        this.slider = new PrefsSlider(0, 0, 150, 16, preference, (Component)new TextComponent(prefix), (Component)new TextComponent(suffix), minVal, maxVal, curVal, showDec, showStr, isSwitch, button -> {});
        if (!isSwitch) {
            this.textField = new EditBox(font, 0, 0, 36, 16, (Component)new TranslatableComponent(""));
            this.textField.m_94199_(5);
            this.textField.m_94144_(this.slider.m_6035_().getString());
        }
        this.button = new Button(0, 0, 16 + (isSwitch ? 36 : 0), 16, (Component)new TranslatableComponent(isSwitch ? "RESET" : "R"), button -> this.resetValue());
    }

    public void resetValue() {
        this.slider.setValue(this.defaultVal);
        this.slider.updateSlider();
        if (this.isSwitch) {
            this.slider.m_93666_((Component)new TextComponent(this.slider.getValue() == 1.0 ? "On" : "Off"));
        } else {
            this.textField.m_94144_(this.slider.m_6035_().getString());
        }
    }

    public int getWidth() {
        return 202;
    }

    public int getHeight() {
        return 27;
    }

    public int getX() {
        return this.slider.f_93620_;
    }

    public int getY() {
        return this.slider.f_93621_;
    }

    public void setX(int x) {
        this.slider.f_93620_ = x;
        if (this.isSwitch) {
            this.button.f_93620_ = x + 150;
        } else {
            this.button.f_93620_ = x + 150 + 36;
            this.textField.f_93620_ = x + 150;
        }
    }

    public void setY(int y) {
        this.slider.f_93621_ = y;
        this.button.f_93621_ = y;
        if (!this.isSwitch) {
            this.textField.f_93621_ = y;
        }
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        this.slider.m_6375_(mouseX, mouseY, button);
        this.button.m_6375_(mouseX, mouseY, button);
    }

    public void mouseReleased(double mouseX, double mouseY, int button) {
        this.slider.m_6348_(mouseX, mouseY, button);
        this.button.m_6348_(mouseX, mouseY, button);
    }

    public void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.slider.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        this.button.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.slider.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.button.m_6305_(stack, mouseX, mouseY, partialTicks);
        if (this.textField != null) {
            this.textField.m_6305_(stack, mouseX, mouseY, partialTicks);
        }
    }
}

