/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.ConfigHelper;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.PlayerTickHandler;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.PmmoScreen;
import harmonised.pmmo.gui.PrefsChoiceScreen;
import harmonised.pmmo.gui.PrefsEntry;
import harmonised.pmmo.gui.PrefsScrollPanel;
import harmonised.pmmo.gui.TileButton;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PrefsScreen
extends PmmoScreen {
    public static Map<String, Double> prefsMap;
    private final ResourceLocation box = XP.getResLoc("pmmo", "textures/gui/screenboxy.png");
    private int i;
    private double value;
    private static Button exitButton;
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int buttonX;
    private PrefsScrollPanel scrollPanel;
    private final JType jType;
    private ArrayList<PrefsEntry> prefsEntries;
    private Component title;
    private Player player;

    public PrefsScreen(Component titleIn, JType jType) {
        super(titleIn);
        this.player = Minecraft.m_91087_().f_91074_;
        this.title = titleIn;
        this.jType = jType;
    }

    protected void m_7856_() {
        prefsMap = Config.getPreferencesMap(this.player);
        this.x = this.sr.m_85445_() / 2 - this.boxWidth / 2;
        this.y = this.sr.m_85446_() / 2 - this.boxHeight / 2;
        this.scrollX = this.x + 16;
        this.scrollY = this.y + 10;
        this.buttonX = this.scrollX + 4;
        exitButton = new TileButton(this.x + this.boxWidth - 24, this.y - 8, 7, 0, "", JType.SKILLS, button -> Minecraft.m_91087_().m_91152_((Screen)new PrefsChoiceScreen((Component)new TranslatableComponent("pmmo.stats"))));
        this.prefsEntries = new ArrayList();
        switch (this.jType) {
            case SETTINGS: {
                this.value = Math.min((double)Skill.getLevel(Skill.BUILDING.toString(), this.player) / Config.getConfig("levelsPerOneReach"), Config.getConfig("maxExtraReachBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraReachBoost, "maxExtraReachBoost", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.ENDURANCE.toString(), this.player) / Config.getConfig("levelsPerHeart"), Config.getConfig("maxExtraHeartBoost"));
                this.addPrefsButtonInteger(Config.forgeConfig.maxExtraHeartBoost, "maxExtraHeartBoost", 0.0, this.value, false, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.COMBAT.toString(), this.player) * Config.getConfig("damageBonusPercentPerLevelMelee"), Config.getConfig("maxExtraDamagePercentageBoostMelee"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraDamagePercentageBoostMelee, "maxExtraDamagePercentageBoostMelee", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.ARCHERY.toString(), this.player) * Config.getConfig("damageBonusPercentPerLevelArchery"), Config.getConfig("maxExtraDamagePercentageBoostArchery"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraDamagePercentageBoostArchery, "maxExtraDamagePercentageBoostArchery", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.MAGIC.toString(), this.player) * Config.getConfig("damageBonusPercentPerLevelMagic"), Config.getConfig("maxExtraDamagePercentageBoostMagic"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxExtraDamagePercentageBoostMagic, "maxExtraDamagePercentageBoostMagic", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.AGILITY.toString(), this.player) * Config.getConfig("speedBoostPerLevel"), Config.getConfig("maxSpeedBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxSpeedBoost, "maxSpeedBoost", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.AGILITY.toString(), this.player) * Config.getConfig("levelsPerSprintJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxJumpBoost, "maxSprintJumpBoost", 0.0, this.value, true, true, true);
                this.value = Math.min((double)Skill.getLevel(Skill.AGILITY.toString(), this.player) * Config.getConfig("levelsPerCrouchJumpBoost"), Config.getConfig("maxJumpBoost"));
                this.addPrefsButtonDouble(Config.forgeConfig.maxJumpBoost, "maxCrouchJumpBoost", 0.0, this.value, true, true, true);
                this.addPrefsButtonBool(Config.forgeConfig.wipeAllSkillsUponDeathPermanently, "wipeAllSkillsUponDeathPermanently", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.spawnFireworksCausedByMe, "spawnFireworksCausedByMe", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.spawnFireworksCausedByOthers, "spawnFireworksCausedByOthers", false, true, false);
                if (!XP.isNightvisionUnlocked(this.player)) break;
                this.addPrefsButtonBool(Config.forgeConfig.underwaterNightVision, "underwaterNightVision", false, true, false);
                break;
            }
            case GUI_SETTINGS: {
                this.addPrefsButtonDouble(Config.forgeConfig.barOffsetX, "barOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.barOffsetY, "barOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.veinBarOffsetX, "veinBarOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.veinBarOffsetY, "veinBarOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropOffsetX, "xpDropOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropOffsetY, "xpDropOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.skillListOffsetX, "skillListOffsetX", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.skillListOffsetY, "skillListOffsetY", 0.0, 1.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropSpawnDistance, "xpDropSpawnDistance", 0.0, 1000.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropOpacityPerTime, "xpDropOpacityPerTime", 0.0, 255.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropMaxOpacity, "xpDropMaxOpacity", 0.0, 255.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.xpDropDecayAge, "xpDropDecayAge", 0.0, 5000.0, false, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.minXpGrow, "minXpGrow", 0.01, 100.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.worldXpDropsSizeMultiplier, "worldXpDropsSizeMultiplier", 0.01, 100.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.worldXpDropsDecaySpeedMultiplier, "worldXpDropsDecaySpeedMultiplier", 0.01, 100.0, true, true, false);
                this.addPrefsButtonDouble(Config.forgeConfig.worldXpDropsRotationCap, "worldXpDropsRotationCap", 0.01, 100.0, true, true, false);
                this.addPrefsButtonInteger(Config.forgeConfig.maxVeinDisplay, "maxVeinDisplay", 0.0, 10000.0, false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showSkillsListAtCorner, "showSkillsListAtCorner", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showXpDrops, "showXpDrops", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.stackXpDrops, "stackXpDrops", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpDropsAttachedToBar, "xpDropsAttachedToBar", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpBarAlwaysOn, "xpBarAlwaysOn", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpLeftDisplayAlwaysOn, "xpLeftDisplayAlwaysOn", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.lvlUpScreenshot, "lvlUpScreenshot", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.xpDropsShowXpBar, "xpDropsShowXpBar", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showLevelUpUnlocks, "showLevelUpUnlocks", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.worldXpDropsEnabled, "worldXpDropsEnabled", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.worldXpDropsShowSkill, "worldXpDropsShowSkill", false, true, false);
                this.addPrefsButtonBool(Config.forgeConfig.showOthersWorldXpDrops, "showOthersWorldXpDrops", false, true, false);
            }
        }
        this.i = 0;
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!prefEntry.isSwitch) {
                prefEntry.textField.m_94151_(text -> {
                    try {
                        this.value = Double.parseDouble(text);
                        if (this.value > prefEntry.slider.maxValue) {
                            this.value = prefEntry.slider.maxValue;
                        }
                        if (this.value < prefEntry.slider.minValue) {
                            this.value = prefEntry.slider.minValue;
                        }
                        prefEntry.slider.setValue(this.value);
                        prefEntry.slider.updateSlider();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                prefEntry.textField.m_94153_(text -> text.matches("^[0-9]{0,3}[.]?[0-9]*$") && text.replace(".", "").length() < 5);
            }
            prefEntry.slider.setResponder(slider -> {
                slider.precision = 4;
                prefsMap.put(slider.preference, slider.getValue());
                if (prefEntry.removeIfMax && slider.getValue() == slider.maxValue) {
                    prefsMap.remove(slider.preference);
                }
                XPOverlayGUI.doInit();
                PlayerTickHandler.syncPrefs = true;
            });
            prefEntry.slider.updateSlider();
            prefEntry.setX(this.x + 24);
            prefEntry.setY(this.y + 24 + 18 * this.i++);
        }
        this.scrollPanel = new PrefsScrollPanel(new PoseStack(), Minecraft.m_91087_(), this.boxWidth - 40, this.boxHeight - 21, this.scrollY, this.scrollX, this.prefsEntries);
        if (!MainScreen.scrollAmounts.containsKey((Object)this.jType)) {
            MainScreen.scrollAmounts.put(this.jType, 0);
        }
        this.scrollPanel.setScroll(MainScreen.scrollAmounts.get((Object)this.jType));
        this.f_96540_.add(this.scrollPanel);
        this.m_7787_((GuiEventListener)exitButton);
    }

    private void addPrefsButtonBool(ConfigHelper.ConfigValueListener<Boolean> config, String key, boolean showDec, boolean showStr, boolean removeIfMax) {
        this.addPrefsButtonValue(key, config.get() != false ? 1.0 : 0.0, 0.0, 1.0, showDec, showStr, removeIfMax, true);
    }

    private void addPrefsButtonInteger(ConfigHelper.ConfigValueListener<Integer> config, String key, double min, double max, boolean showDec, boolean showStr, boolean removeIfMax) {
        this.addPrefsButtonValue(key, config.get().intValue(), min, max, showDec, showStr, removeIfMax, false);
    }

    private void addPrefsButtonDouble(ConfigHelper.ConfigValueListener<Double> config, String key, double min, double max, boolean showDec, boolean showStr, boolean removeIfMax) {
        this.addPrefsButtonValue(key, config.get(), min, max, showDec, showStr, removeIfMax, false);
    }

    private void addPrefsButtonValue(String key, double value, double min, double max, boolean showDec, boolean showStr, boolean removeIfMax, boolean isSwitch) {
        this.prefsEntries.add(new PrefsEntry(key, "", "", min, max, prefsMap.getOrDefault(key, value), value, showDec, showStr, removeIfMax, isSwitch));
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_96558_(stack, 1);
        if (this.f_96547_.m_92895_(this.title.getString()) > 220) {
            PrefsScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.title.getString(), (int)(this.sr.m_85445_() / 2), (int)(this.y - 10), (int)0xFFFFFF);
        } else {
            PrefsScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.title.getString(), (int)(this.sr.m_85445_() / 2), (int)(this.y - 5), (int)0xFFFFFF);
        }
        this.x = this.sr.m_85445_() / 2 - this.boxWidth / 2;
        this.y = this.sr.m_85446_() / 2 - this.boxHeight / 2;
        this.scrollPanel.m_6305_(stack, mouseX, mouseY, partialTicks);
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (mouseX < prefEntry.button.f_93620_ || mouseX >= prefEntry.button.f_93620_ + prefEntry.button.m_5711_() || mouseY < prefEntry.button.f_93621_ || mouseY >= prefEntry.button.f_93621_ + prefEntry.button.m_93694_()) continue;
            this.m_96602_(stack, (Component)new TranslatableComponent(prefEntry.isSwitch ? (prefEntry.defaultVal == 1.0 ? "ON" : "OFF") : (prefEntry.removeIfMax && prefEntry.defaultVal == prefEntry.slider.maxValue ? "MAX" : DP.dpSoft(prefEntry.defaultVal))), mouseX, mouseY);
        }
        MainScreen.scrollAmounts.replace(this.jType, this.scrollPanel.getScroll());
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    public void m_96558_(PoseStack stack, int p_renderBackground_1_) {
        if (this.f_96541_ != null && !this.jType.equals((Object)JType.GUI_SETTINGS)) {
            this.boxHeight = 256;
            this.boxWidth = 256;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.box);
            this.m_93179_(stack, 0, 0, this.f_96543_, this.f_96544_, 0x66222222, 0x66333333);
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundDrawnEvent((Screen)this, stack));
            this.m_93228_(stack, this.x, this.y, 0, 0, this.boxWidth, this.boxHeight);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.prefsEntries.size() >= 9) {
            this.scrollPanel.m_6050_(mouseX, mouseY, scroll);
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            exitButton.m_5691_();
            return true;
        }
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseClicked(mouseX, mouseY, button);
            if (prefEntry.isSwitch || !prefEntry.textField.m_6375_(mouseX, mouseY, button)) continue;
            this.m_94718_((GuiEventListener)prefEntry.textField);
            prefEntry.textField.m_94178_(true);
        }
        this.scrollPanel.m_6375_(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseReleased(mouseX, mouseY, button);
        }
        this.scrollPanel.m_6348_(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        for (PrefsEntry prefEntry : this.prefsEntries) {
            if (!(mouseY >= (double)this.scrollPanel.getTop()) || !(mouseY <= (double)this.scrollPanel.getBottom())) continue;
            prefEntry.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        this.scrollPanel.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public static TranslatableComponent getTransComp(String translationKey, Double ... args) {
        return new TranslatableComponent(translationKey, (Object[])args);
    }
}

