/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import harmonised.pmmo.gui.PmmoScreen;
import harmonised.pmmo.gui.StatsEntry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.client.gui.ScrollPanel;
import org.lwjgl.opengl.GL11;

public class StatsScrollPanel
extends ScrollPanel {
    Window sr;
    private final int boxWidth = 256;
    private final int boxHeight = 256;
    private final List<StatsEntry> statsEntries;
    private StatsEntry statsEntry;
    private Font font;
    private final Minecraft client;
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    private final int right;
    private final int left;
    private final int barLeft;
    private final int border = 4;
    private final int barWidth = 6;

    public StatsScrollPanel(PoseStack stack, Minecraft client, int width, int height, int top, int left, List<StatsEntry> statsEntries) {
        super(client, width, height, top, left);
        this.statsEntries = statsEntries;
        this.sr = Minecraft.m_91087_().m_91268_();
        this.font = Minecraft.m_91087_().f_91062_;
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.left = left;
        this.bottom = height + this.top;
        this.right = width + this.left;
        this.barLeft = this.left + this.width - 6;
    }

    protected int getContentHeight() {
        int height = 16;
        for (StatsEntry a : this.statsEntries) {
            height += a.getHeight() + 3;
        }
        return height;
    }

    protected void drawPanel(PoseStack stack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        int accumulativeHeight = 0;
        for (int i = 0; i < this.statsEntries.size(); ++i) {
            this.statsEntry = this.statsEntries.get(i);
            this.statsEntry.setX(this.left + 6);
            this.statsEntry.setY(relativeY + accumulativeHeight);
            TextColor color = this.statsEntry.title.m_7383_().m_131135_();
            int hexColor = color == null ? 0xFFFFFF : color.m_131265_();
            this.m_93179_(stack, this.left + 4, this.statsEntry.getY() - 2, this.right - 2, this.statsEntry.getY() + this.statsEntry.getHeight() + 2, 0x22444444, 0x33222222);
            StatsScrollPanel.m_93208_((PoseStack)stack, (Font)this.font, (String)this.statsEntry.title.getString(), (int)(this.sr.m_85445_() / 2), (int)this.statsEntry.getY(), (int)hexColor);
            for (int j = 0; j < this.statsEntry.text.size(); ++j) {
                MutableComponent line = this.statsEntry.text.get(j);
                color = line.m_7383_().m_131135_();
                hexColor = color == null ? 0xFFFFFF : color.m_131265_();
                StatsScrollPanel.m_93236_((PoseStack)stack, (Font)this.font, (String)line.getString(), (int)this.statsEntry.getX(), (int)(2 + this.statsEntry.getY() + (j + 1) * 11), (int)hexColor);
            }
            accumulativeHeight += this.statsEntry.getHeight() + 4;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public int getScroll() {
        return (int)this.scrollDistance;
    }

    public void setScroll(int scroll) {
        this.scrollDistance = scroll;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRelativeY() {
        return this.top + this.border - (int)this.scrollDistance;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder worldr = tess.m_85915_();
        double scale = this.client.m_91268_().m_85449_();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.client.m_91268_().m_85442_() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(stack, this.right, baseY, tess, mouseX, mouseY);
        RenderSystem.m_69465_();
        int extraHeight = this.getContentHeight() + 4 - this.height;
        if (extraHeight > 0) {
            int barHeight = this.getBarHeight();
            int barTop = (int)this.scrollDistance * (this.height - barHeight) / extraHeight + this.top;
            if (barTop < this.top) {
                barTop = this.top;
            }
            RenderSystem.m_69472_();
            worldr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            worldr.m_5483_((double)this.barLeft, (double)this.bottom, 0.0).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)this.bottom, 0.0).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)this.top, 0.0).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            worldr.m_5483_((double)this.barLeft, (double)this.top, 0.0).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
            tess.m_85914_();
            worldr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            worldr.m_5483_((double)this.barLeft, (double)(barTop + barHeight), 0.0).m_7421_(0.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)(barTop + barHeight), 0.0).m_7421_(1.0f, 1.0f).m_6122_(128, 128, 128, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6), (double)barTop, 0.0).m_7421_(1.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            worldr.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_7421_(0.0f, 0.0f).m_6122_(128, 128, 128, 255).m_5752_();
            tess.m_85914_();
            worldr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            worldr.m_5483_((double)this.barLeft, (double)(barTop + barHeight - 1), 0.0).m_7421_(0.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6 - 1), (double)(barTop + barHeight - 1), 0.0).m_7421_(1.0f, 1.0f).m_6122_(192, 192, 192, 255).m_5752_();
            worldr.m_5483_((double)(this.barLeft + 6 - 1), (double)barTop, 0.0).m_7421_(1.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
            worldr.m_5483_((double)this.barLeft, (double)barTop, 0.0).m_7421_(0.0f, 0.0f).m_6122_(192, 192, 192, 255).m_5752_();
            tess.m_85914_();
        }
        RenderSystem.m_69493_();
        PmmoScreen.enableAlpha(1.0f);
        RenderSystem.m_69461_();
        GL11.glDisable((int)3089);
    }

    private int getBarHeight() {
        int barHeight = this.height * this.height / this.getContentHeight();
        if (barHeight < 32) {
            barHeight = 32;
        }
        if (barHeight > this.height - 8) {
            barHeight = this.height - 8;
        }
        return barHeight;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return null;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }
}

