/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.party;

import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.party.PartyMemberInfo;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class PartyPendingSystem {
    public static CompoundTag offlineData = new CompoundTag();
    public static Map<UUID, UUID> pendingInvitations = new HashMap<UUID, UUID>();
    public static Map<UUID, Long> invitationDates = new HashMap<UUID, Long>();
    public static final long expirationTime = 300000L;

    public static UUID getOwnerUUID(UUID inviteeUUID) {
        UUID ownerUUID = null;
        if (pendingInvitations.containsKey(inviteeUUID)) {
            ownerUUID = pendingInvitations.get(inviteeUUID);
        }
        return ownerUUID;
    }

    public static int createInvitation(ServerPlayer invitee, UUID ownerUUID) {
        PmmoSavedData pmmoSavedData = PmmoSavedData.get();
        Party ownerParty = pmmoSavedData.getParty(ownerUUID);
        UUID inviteeUUID = invitee.m_142081_();
        if (pendingInvitations.containsKey(inviteeUUID) && pendingInvitations.get(inviteeUUID).equals(ownerUUID)) {
            return -3;
        }
        if (ownerParty == null) {
            return -1;
        }
        if (pmmoSavedData.getParty(inviteeUUID) != null) {
            return -2;
        }
        if (ownerParty.getMembersCount() + 1 > Party.getMaxPartyMembers()) {
            return -4;
        }
        pendingInvitations.put(inviteeUUID, ownerUUID);
        invitationDates.put(inviteeUUID, System.currentTimeMillis());
        return 0;
    }

    public static int acceptInvitation(ServerPlayer invitee, UUID ownerUUID) {
        UUID inviteeUUID = invitee.m_142081_();
        int result = -3;
        if (pendingInvitations.containsKey(inviteeUUID)) {
            long createdAgo = invitationDates.get(inviteeUUID);
            invitationDates.remove(inviteeUUID);
            if (System.currentTimeMillis() - createdAgo <= 300000L) {
                PmmoSavedData pmmoSavedData = PmmoSavedData.get();
                result = pmmoSavedData.addToParty(ownerUUID, inviteeUUID);
            }
        }
        pendingInvitations.remove(inviteeUUID);
        return result;
    }

    public static boolean declineInvitation(UUID inviteeUUID) {
        boolean success = false;
        if (pendingInvitations.containsKey(inviteeUUID)) {
            success = true;
        }
        pendingInvitations.remove(inviteeUUID);
        return success;
    }

    public static void sendPlayerOfflineData(ServerPlayer player) {
        CompoundTag partyData = new CompoundTag();
        Party party = PmmoSavedData.get().getParty(player.m_142081_());
        if (party != null) {
            Set<PartyMemberInfo> membersInfo = party.getAllMembersInfo();
            for (PartyMemberInfo partyMemberInfo : membersInfo) {
                UUID uuid = partyMemberInfo.uuid;
                ServerPlayer partyMember = XP.getPlayerByUUID(uuid);
                CompoundTag partyMemberData = new CompoundTag();
                if (partyMember != null) {
                    partyMemberData.m_128350_("maxHp", partyMember.m_21233_());
                    partyMemberData.m_128350_("hp", partyMember.m_21223_());
                    partyMemberData.m_128359_("dim", XP.getDimResLoc(partyMember.f_19853_).toString());
                    Vec3 pos = partyMember.m_20182_();
                    partyMemberData.m_128347_("x", pos.m_7096_());
                    partyMemberData.m_128347_("y", pos.m_7098_());
                    partyMemberData.m_128347_("z", pos.m_7094_());
                }
                partyData.m_128365_(PmmoSavedData.get().getName(uuid), (Tag)partyMemberData);
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(partyData, 7), player);
    }
}

