/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.perks;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.function.TriFunction;

public class EventPerks {
    private static final String PER_LEVEL = "per_level";
    private static final String MAX_BOOST = "max_boost";
    private static final String COOLDOWN = "cooldown";
    private static Map<UUID, Long> breathe_cooldown = new HashMap<UUID, Long>();
    public static TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> JUMP = (player, nbt, level) -> {
        double perLevel = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 5.0E-4;
        double maxBoost = nbt.m_128441_(MAX_BOOST) ? nbt.m_128459_(MAX_BOOST) : 0.33;
        double jumpBoost = -0.011 + (double)level.intValue() * perLevel;
        jumpBoost = Math.min(maxBoost, jumpBoost);
        player.m_5997_(0.0, jumpBoost, 0.0);
        player.f_19864_ = true;
        CompoundTag output = new CompoundTag();
        output.m_128347_("power", jumpBoost);
        return output;
    };
    public static TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> BREATH = (player, nbt, level) -> {
        long cooldown = nbt.m_128441_(COOLDOWN) ? nbt.m_128454_(COOLDOWN) : 300L;
        double strength = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 1.0;
        int perLevel = Math.max(1, (int)((double)level.intValue() * strength));
        long currentCD = breathe_cooldown.getOrDefault(player.m_142081_(), System.currentTimeMillis());
        int currentAir = player.m_20146_();
        if (currentAir < 2 && (currentCD < System.currentTimeMillis() - cooldown || currentCD + 20L >= System.currentTimeMillis())) {
            player.m_20301_(currentAir + perLevel);
            player.m_9146_((Component)new TranslatableComponent("pmmo.perks.breathrefresh"), ChatType.GAME_INFO, player.m_142081_());
            breathe_cooldown.put(player.m_142081_(), System.currentTimeMillis());
        }
        return new CompoundTag();
    };
    public static TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> FALL_SAVE = (player, nbt, level) -> {
        CompoundTag output = new CompoundTag();
        double perLevel = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 0.1;
        int saved = (int)(perLevel * (double)level.intValue());
        output.m_128405_("saved", saved);
        return output;
    };
    public static TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> DAMAGE_BOOST = (player, nbt, level) -> {
        CompoundTag output = new CompoundTag();
        if (!nbt.m_128441_("damageIn")) {
            return output;
        }
        double perLevel = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 0.05;
        float damage = nbt.m_128457_("damageIn") * (float)(perLevel * (double)level.intValue());
        output.m_128350_("damage", damage);
        return output;
    };
}

