/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.proxy;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.InfoScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.gui.WorldRenderHandler;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final KeyMapping SHOW_BAR = new KeyMapping("key.pmmo.showBar", 258, "category.pmmo");
    public static final KeyMapping SHOW_LIST = new KeyMapping("key.pmmo.showList", 342, "category.pmmo");
    public static final KeyMapping TOGGLE_TOOLTIP = new KeyMapping("key.pmmo.toggleTooltip", 295, "category.pmmo");
    public static final KeyMapping VEIN_KEY = new KeyMapping("key.pmmo.vein", 96, "category.pmmo");
    public static final KeyMapping OPEN_MENU = new KeyMapping("key.pmmo.openMenu", 80, "category.pmmo");
    public static final KeyMapping OPEN_SETTINGS = new KeyMapping("key.pmmo.openSettings", -1, "category.pmmo");
    public static final KeyMapping OPEN_SKILLS = new KeyMapping("key.pmmo.openSkills", -1, "category.pmmo");
    public static final KeyMapping OPEN_GLOSSARY = new KeyMapping("key.pmmo.openGlossary", -1, "category.pmmo");
    public static Map<String, Map<String, Map<String, Double>>> hiscoreMap = new HashMap<String, Map<String, Map<String, Double>>>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new XPOverlayGUI());
        MinecraftForge.EVENT_BUS.register((Object)new WorldRenderHandler());
        ClientRegistry.registerKeyBinding((KeyMapping)SHOW_BAR);
        ClientRegistry.registerKeyBinding((KeyMapping)SHOW_LIST);
        ClientRegistry.registerKeyBinding((KeyMapping)TOGGLE_TOOLTIP);
        ClientRegistry.registerKeyBinding((KeyMapping)VEIN_KEY);
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_MENU);
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_SETTINGS);
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_SKILLS);
        ClientRegistry.registerKeyBinding((KeyMapping)OPEN_GLOSSARY);
    }

    public static void updateNBTTag(MessageUpdatePlayerNBT packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        CompoundTag newPackage = packet.reqPackage;
        Set keySet = newPackage.m_128431_();
        switch (packet.type) {
            case 0: {
                Map<String, Double> prefsMap = Config.getPreferencesMap((Player)player);
                for (String tag : keySet) {
                    prefsMap.put(tag, newPackage.m_128459_(tag));
                }
                XPOverlayGUI.doInit();
                break;
            }
            case 1: {
                Map<String, Double> abilitiesMap = Config.getAbilitiesMap((Player)player);
                for (String tag : keySet) {
                    abilitiesMap.put(tag, newPackage.m_128459_(tag));
                }
                if (!XP.isPlayerSurvival((Player)player)) break;
                XPOverlayGUI.updateVein();
                break;
            }
            case 6: {
                Config.xpBoosts = NBTHelper.nbtToMapStringString(newPackage);
                break;
            }
            case 7: {
                break;
            }
            default: {
                LOGGER.error("ERROR MessageUpdateNBT WRONG TYPE");
            }
        }
    }

    public static void openStats(UUID uuid) {
        Minecraft.m_91087_().m_91152_((Screen)new ListScreen(uuid, (Component)new TranslatableComponent("pmmo.skills"), "", JType.SKILLS, (Player)Minecraft.m_91087_().f_91074_));
    }

    public static void syncPrefsToServer() {
        NetworkHandler.sendToServer(new MessageUpdatePlayerNBT(NBTHelper.mapStringToNbt(Config.getPreferencesMap((Player)Minecraft.m_91087_().f_91074_)), 0));
    }

    public static void openInfoMenu() {
        Minecraft.m_91087_().m_91152_((Screen)new InfoScreen(Minecraft.m_91087_().f_91074_.m_142081_(), (Component)new TranslatableComponent("pmmo.info")));
    }
}

