/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.skills;

import harmonised.pmmo.api.perks.PerkRegistry;
import harmonised.pmmo.api.perks.PerkTrigger;
import harmonised.pmmo.commands.PmmoCommand;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public enum Skill {
    INVALID_SKILL(0xFFFFFF),
    MINING(65535),
    BUILDING(65535),
    EXCAVATION(15112448),
    WOODCUTTING(16753434),
    FARMING(58880),
    AGILITY(0x66CC66),
    ENDURANCE(0xCC0000),
    COMBAT(0xFF3300),
    GUNSLINGING(13877667),
    ARCHERY(0xFFFF00),
    SMITHING(0xF0F0F0),
    FLYING(0xCCCCFF),
    SWIMMING(0x3366FF),
    SAILING(10073087),
    FISHING(52479),
    CRAFTING(0xFF9900),
    MAGIC(255),
    SLAYER(0xFFFFFF),
    HUNTER(13596693),
    TAMING(0xFFFFFF),
    COOKING(15112448),
    ALCHEMY(15112448);

    private static final Map<String, Integer> validSkills;
    private static final Map<String, Style> skillStyle;
    public final String name = this.name();
    public final int color;

    private Skill(int color) {
        this.color = color;
    }

    public static void setSkill(String skill, int color) {
        if (!(skill = skill.toLowerCase()).equals(INVALID_SKILL.toString())) {
            validSkills.put(skill, color);
            skillStyle.put(skill, Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)));
        }
    }

    public static int getSkillColor(String skill) {
        return validSkills.getOrDefault(skill, 0xFFFFFF);
    }

    public static Style getSkillStyle(String skill) {
        return skillStyle.getOrDefault(skill, Style.f_131099_);
    }

    public static void updateSkills() {
        for (Map.Entry<JType, Map<String, Map<String, Double>>> map : JsonConfig.data.entrySet()) {
            for (Map.Entry entry : ((Map)JsonConfig.data.getOrDefault((Object)map.getKey(), new HashMap())).entrySet()) {
                Skill.setSkill((String)entry.getKey(), ((Map)JsonConfig.data.getOrDefault((Object)JType.SKILLS, new HashMap())).containsKey("color") ? (int)Math.floor((Double)((Map)entry.getValue()).get("color")) : 0xFFFFFF);
            }
        }
        PmmoCommand.init();
    }

    public static void setSkillStyle(String skill, Style style) {
        skillStyle.put(skill.toLowerCase(), style);
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public boolean equals(String string) {
        return this.toString().equals(string.toLowerCase());
    }

    public static Map<String, Integer> getSkills() {
        return new HashMap<String, Integer>(validSkills);
    }

    @Deprecated
    public static int getLevel(String skill, Player player) {
        if (player.f_19853_.f_46443_) {
            return XP.getOfflineLevel(skill, player.m_142081_());
        }
        return PmmoSavedData.get().getLevel(skill, player.m_142081_());
    }

    public static int getLevel(String skill, UUID uuid) {
        return PmmoSavedData.get().getLevel(skill, uuid);
    }

    public static double getLevelDecimal(String skill, Player player) {
        if (player.f_19853_.f_46443_) {
            return XP.getOfflineLevelDecimal(skill, player.m_142081_());
        }
        return PmmoSavedData.get().getLevelDecimal(skill, player.m_142081_());
    }

    public static double getLevelDecimal(String skill, UUID uuid) {
        return PmmoSavedData.get().getLevelDecimal(skill, uuid);
    }

    @Deprecated
    public static double getXp(String skill, Player player) {
        if (player.f_19853_.f_46443_) {
            return XP.getOfflineXp(skill, player.m_142081_());
        }
        return PmmoSavedData.get().getXp(skill, player.m_142081_());
    }

    public static double getXp(String skill, UUID uuid) {
        return PmmoSavedData.get().getXp(skill, uuid);
    }

    @Deprecated
    public static void setLevel(String skill, ServerPlayer player, double amount) {
        Skill.setXp(skill, player, XP.xpAtLevelDecimal(amount));
    }

    public static void setXp(String skill, UUID uuid, double amount) {
        ServerPlayer player = PmmoSavedData.getServer().m_6846_().m_11259_(uuid);
        if (player == null) {
            PmmoSavedData.get().setXp(skill, uuid, amount);
        } else {
            Skill.setXp(skill, player, amount);
        }
    }

    @Deprecated
    public static void setXp(String skill, ServerPlayer player, double amount) {
        if (PmmoSavedData.get().setXp(skill, player.m_142081_(), amount)) {
            PerkRegistry.executePerk(PerkTrigger.SKILL_UP, player);
            XP.updateRecipes(player);
            NetworkHandler.sendToPlayer(new MessageXp(amount, skill, 0.0, false), player);
        }
    }

    @Deprecated
    public static void addLevel(String skill, UUID uuid, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        double missingXp = XP.xpAtLevelDecimal(Skill.getLevelDecimal(skill, uuid) + amount) - Skill.getXp(skill, uuid);
        Skill.addXp(skill, uuid, missingXp, sourceName, skip, ignoreBonuses);
    }

    public static void addLevel(String skill, ServerPlayer player, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        double missingXp = XP.xpAtLevelDecimal(Skill.getLevelDecimal(skill, (Player)player) + amount) - Skill.getXp(skill, (Player)player);
        Skill.addXp(skill, player, missingXp, sourceName, skip, ignoreBonuses);
    }

    @Deprecated
    public static void addXp(String skill, UUID uuid, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        ServerPlayer player = PmmoSavedData.getServer().m_6846_().m_11259_(uuid);
        if (player == null) {
            PmmoSavedData.get().scheduleXp(skill, uuid, amount, sourceName);
        } else {
            Skill.addXp(skill, player, amount, sourceName, skip, ignoreBonuses);
        }
    }

    public static void addXp(String skill, ServerPlayer player, double amount, String sourceName, boolean skip, boolean ignoreBonuses) {
        XP.awardXp(player, skill, sourceName, amount, skip, ignoreBonuses, false);
    }

    static {
        validSkills = new HashMap<String, Integer>();
        skillStyle = new HashMap<String, Style>();
        for (Skill skill : Skill.values()) {
            Skill.setSkill(skill.name, skill.color);
        }
    }
}

