/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api.perks;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.perks.PerkTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.function.TriFunction;

public class PerkRegistry {
    private static Map<ResourceLocation, TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag>> perkExecutions = new HashMap<ResourceLocation, TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag>>();
    private static Map<ResourceLocation, TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag>> perkTerminations = new HashMap<ResourceLocation, TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag>>();
    private static Map<PerkTrigger, LinkedListMultimap<String, JsonObject>> perkSettings = new HashMap<PerkTrigger, LinkedListMultimap<String, JsonObject>>();

    public static void setSettings(Map<PerkTrigger, LinkedListMultimap<String, JsonObject>> settings) {
        perkSettings = settings;
    }

    public static void registerPerk(ResourceLocation perkID, TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> onExecute, TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> onConclude) {
        Preconditions.checkNotNull((Object)perkID);
        Preconditions.checkNotNull(onExecute);
        Preconditions.checkNotNull(onConclude);
        perkExecutions.put(perkID, onExecute);
        perkTerminations.put(perkID, onConclude);
    }

    public static CompoundTag executePerk(PerkTrigger cause, ServerPlayer player) {
        return PerkRegistry.executePerk(cause, player, new CompoundTag());
    }

    public static CompoundTag executePerk(PerkTrigger cause, ServerPlayer player, CompoundTag dataIn) {
        LinkedListMultimap<String, JsonObject> map = perkSettings.getOrDefault((Object)cause, (LinkedListMultimap<String, JsonObject>)LinkedListMultimap.create());
        CompoundTag output = new CompoundTag();
        for (String skill : map.keySet()) {
            List entries = map.get((Object)skill);
            int skillLevel = APIUtils.getLevel(skill, (Player)player);
            for (int i = 0; i < entries.size(); ++i) {
                CompoundTag src = PerkRegistry.tagFromJson((JsonObject)entries.get(i));
                src.m_128391_(dataIn);
                ResourceLocation perkID = new ResourceLocation(src.m_128461_("perk"));
                output = PerkRegistry.mergeTags(output, (CompoundTag)perkExecutions.getOrDefault(perkID, (TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag>)((TriFunction)(a, b, c) -> new CompoundTag())).apply((Object)player, (Object)src, (Object)skillLevel));
            }
        }
        return output;
    }

    public static CompoundTag terminatePerk(PerkTrigger cause, ServerPlayer player) {
        return PerkRegistry.terminatePerk(cause, player, new CompoundTag());
    }

    public static CompoundTag terminatePerk(PerkTrigger cause, ServerPlayer player, CompoundTag dataIn) {
        LinkedListMultimap<String, JsonObject> map = perkSettings.getOrDefault((Object)cause, (LinkedListMultimap<String, JsonObject>)LinkedListMultimap.create());
        CompoundTag output = new CompoundTag();
        for (String skill : map.keySet()) {
            List entries = map.get((Object)skill);
            int skillLevel = APIUtils.getLevel(skill, (Player)player);
            for (int i = 0; i < entries.size(); ++i) {
                CompoundTag src = PerkRegistry.tagFromJson((JsonObject)entries.get(i));
                src.m_128391_(dataIn);
                ResourceLocation perkID = new ResourceLocation(src.m_128461_("perk"));
                output = PerkRegistry.mergeTags(output, (CompoundTag)perkTerminations.getOrDefault(perkID, (TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag>)((TriFunction)(a, b, c) -> new CompoundTag())).apply((Object)player, (Object)src, (Object)skillLevel));
            }
        }
        return output;
    }

    private static CompoundTag tagFromJson(JsonObject json) {
        try {
            return TagParser.m_129359_((String)json.toString());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return new CompoundTag();
        }
    }

    public static CompoundTag mergeTags(CompoundTag tag1, CompoundTag tag2) {
        CompoundTag output = new CompoundTag();
        ArrayList<String> allKeys = new ArrayList<String>();
        tag1.m_128431_().forEach(s -> allKeys.add((String)s));
        for (String key : tag2.m_128431_()) {
            if (allKeys.contains(key) || key == null) continue;
            allKeys.add(key);
        }
        for (String key : allKeys) {
            if (tag1.m_128441_(key) && tag2.m_128441_(key)) {
                if (tag1.m_128423_(key) instanceof NumericTag) {
                    if (tag1.m_128423_(key) instanceof DoubleTag) {
                        output.m_128347_(key, tag1.m_128459_(key) + tag2.m_128459_(key));
                        continue;
                    }
                    if (tag1.m_128423_(key) instanceof FloatTag) {
                        output.m_128350_(key, tag1.m_128457_(key) + tag2.m_128457_(key));
                        continue;
                    }
                    if (tag1.m_128423_(key) instanceof IntTag) {
                        output.m_128405_(key, tag1.m_128451_(key) + tag2.m_128451_(key));
                        continue;
                    }
                    if (tag1.m_128423_(key) instanceof LongTag) {
                        output.m_128356_(key, tag1.m_128454_(key) + tag2.m_128454_(key));
                        continue;
                    }
                    if (tag1.m_128423_(key) instanceof ShortTag) {
                        output.m_128376_(key, (short)(tag1.m_128448_(key) + tag2.m_128448_(key)));
                        continue;
                    }
                    output.m_128365_(key, tag1.m_128423_(key));
                    continue;
                }
                output.m_128365_(key, tag1.m_128423_(key));
                continue;
            }
            if (tag1.m_128441_(key) && !tag2.m_128441_(key)) {
                output.m_128365_(key, tag1.m_128423_(key));
                continue;
            }
            if (tag1.m_128441_(key) || !tag2.m_128441_(key)) continue;
            output.m_128365_(key, tag2.m_128423_(key));
        }
        return output;
    }
}

