/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageDoubleTranslation;
import harmonised.pmmo.network.MessageGrow;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;

public class BlockPlacedHandler {
    private static Map<UUID, BlockPos> lastPosPlaced = new HashMap<UUID, BlockPos>();

    public static boolean handlePlaced(Entity entity, BlockState state, Level world, BlockPos pos) {
        if (entity instanceof ServerPlayer && !(entity instanceof FakePlayer)) {
            ServerPlayer player = (ServerPlayer)entity;
            if (XP.isHoldingDebugItemInOffhand((Player)player)) {
                player.m_5661_((Component)new TextComponent(state.m_60734_().getRegistryName().toString()), false);
            }
            if (XP.isPlayerSurvival((Player)player)) {
                Block block = state.m_60734_();
                if (block.equals(Blocks.f_50752_)) {
                    Config.getAbilitiesMap((Player)player).put("veinLeft", Config.forgeConfig.maxVeinCharge.get());
                }
                if (block.equals(Blocks.f_49990_)) {
                    XP.awardXp(player, Skill.MAGIC.toString(), "Walking on water -gasp-", Config.forgeConfig.jesusXp.get(), true, false, false);
                    return false;
                }
                if (XP.checkReq((Player)player, block.getRegistryName(), JType.REQ_PLACE)) {
                    double blockHardnessLimitForPlacing = Config.forgeConfig.blockHardnessLimitForPlacing.get();
                    double blockHardness = state.m_60800_((BlockGetter)world, pos);
                    if (blockHardness > blockHardnessLimitForPlacing) {
                        blockHardness = blockHardnessLimitForPlacing;
                    }
                    UUID playerUUID = player.m_142081_();
                    Map<Object, Object> award = new HashMap();
                    String sourceName = "Placing a Block";
                    if (!lastPosPlaced.containsKey(playerUUID) || !lastPosPlaced.get(playerUUID).equals((Object)pos)) {
                        BlockEntity tile = world.m_7702_(pos);
                        Map<String, Double> map = award = tile == null ? XP.getXpBypass(block.getRegistryName(), JType.XP_VALUE_PLACE) : XP.getXp(tile, JType.XP_VALUE_PLACE);
                        if (award.size() == 0) {
                            if (block.equals(Blocks.f_50093_)) {
                                award.put(Skill.FARMING.toString(), blockHardness);
                                sourceName = "Tilting Dirt";
                            } else {
                                award.put(Skill.BUILDING.toString(), blockHardness);
                            }
                        }
                    }
                    for (String awardSkillName : award.keySet()) {
                        WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.523, (double)pos.m_123343_() + 0.5, 0.35, (Double)award.get(awardSkillName), awardSkillName);
                        XP.addWorldXpDrop(xpDrop, player);
                        Skill.addXp(awardSkillName, player, (double)((Double)award.get(awardSkillName)), sourceName, false, false);
                    }
                    if (lastPosPlaced.containsKey(playerUUID)) {
                        lastPosPlaced.replace(playerUUID, pos);
                    } else {
                        lastPosPlaced.put(playerUUID, pos);
                    }
                } else {
                    ItemStack mainItemStack = player.m_21205_();
                    ItemStack offItemStack = player.m_21206_();
                    if (mainItemStack.m_41720_() instanceof BlockItem) {
                        NetworkHandler.sendToPlayer(new MessageGrow(0, mainItemStack.m_41613_()), player);
                    }
                    if (offItemStack.m_41720_() instanceof BlockItem) {
                        NetworkHandler.sendToPlayer(new MessageGrow(1, offItemStack.m_41613_()), player);
                    }
                    if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(block.getRegistryName().toString()) || block instanceof IPlantable) {
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToPlant", block.m_7705_(), "", true, 2), player);
                    } else {
                        NetworkHandler.sendToPlayer(new MessageDoubleTranslation("pmmo.notSkilledEnoughToPlaceDown", block.m_7705_(), "", true, 2), player);
                    }
                    return true;
                }
            }
        }
        ChunkDataHandler.addPos(XP.getDimResLoc(world), pos, entity.m_142081_());
        return false;
    }
}

