/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.TooltipHandler;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.gui.ListScreen;
import harmonised.pmmo.gui.MainScreen;
import harmonised.pmmo.gui.PrefsChoiceScreen;
import harmonised.pmmo.gui.XPOverlayGUI;
import harmonised.pmmo.network.MessageKeypress;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.util.XP;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static boolean wasVeining = false;
    private static boolean wasOpenMenu = false;
    private static boolean wasOpenSettings = false;
    private static boolean wasOpenSkills = false;
    private static boolean wasOpenGlossary = false;
    private static boolean tooltipKeyWasPressed = false;

    @SubscribeEvent
    public static void keyPressEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            if (wasVeining != ClientHandler.VEIN_KEY.m_90857_()) {
                wasVeining = ClientHandler.VEIN_KEY.m_90857_();
                NetworkHandler.sendToServer(new MessageKeypress(ClientHandler.VEIN_KEY.m_90857_(), 1));
            }
            if (wasOpenMenu != ClientHandler.OPEN_MENU.m_90857_() || wasOpenSettings != ClientHandler.OPEN_SETTINGS.m_90857_() || wasOpenSkills != ClientHandler.OPEN_SKILLS.m_90857_() || wasOpenGlossary != ClientHandler.OPEN_GLOSSARY.m_90857_()) {
                UUID uuid = Minecraft.m_91087_().f_91074_.m_142081_();
                String name = Minecraft.m_91087_().f_91074_.m_5446_().getString();
                XP.playerNames.put(uuid, name);
                XP.playerUUIDs.put(name, uuid);
                XPOverlayGUI.skills.forEach((skill, aSkill) -> XP.getOfflineXpMap(uuid).put((String)skill, aSkill.goalXp));
                if (Minecraft.m_91087_().f_91080_ == null) {
                    if (ClientHandler.OPEN_MENU.m_90857_()) {
                        Minecraft.m_91087_().m_91152_((Screen)new MainScreen(uuid, (Component)new TranslatableComponent("pmmo.potato")));
                        wasOpenMenu = ClientHandler.OPEN_MENU.m_90857_();
                    } else if (ClientHandler.OPEN_SETTINGS.m_90857_()) {
                        Minecraft.m_91087_().m_91152_((Screen)new PrefsChoiceScreen((Component)new TranslatableComponent("pmmo.preferences")));
                        wasOpenSettings = ClientHandler.OPEN_SETTINGS.m_90857_();
                    } else if (ClientHandler.OPEN_SKILLS.m_90857_()) {
                        Minecraft.m_91087_().m_91152_((Screen)new ListScreen(uuid, (Component)new TranslatableComponent("pmmo.skills"), "", JType.SKILLS, (Player)Minecraft.m_91087_().f_91074_));
                        wasOpenSkills = ClientHandler.OPEN_SKILLS.m_90857_();
                    } else if (ClientHandler.OPEN_GLOSSARY.m_90857_()) {
                        Minecraft.m_91087_().m_91152_((Screen)new GlossaryScreen(uuid, (Component)new TranslatableComponent("pmmo.glossary"), true));
                        wasOpenGlossary = ClientHandler.OPEN_GLOSSARY.m_90857_();
                    }
                }
            }
            if (Minecraft.m_91087_().f_91074_ != null && ClientHandler.TOGGLE_TOOLTIP.m_90857_() && !tooltipKeyWasPressed) {
                boolean bl = TooltipHandler.tooltipOn = !TooltipHandler.tooltipOn;
                if (TooltipHandler.tooltipOn) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("pmmo.tooltipOn"), true);
                } else {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)new TranslatableComponent("pmmo.tooltipOff"), true);
                }
            }
            tooltipKeyWasPressed = ClientHandler.TOGGLE_TOOLTIP.m_90857_();
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        TooltipHandler.handleTooltip(event);
    }
}

