/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftedHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handleCrafted(PlayerEvent.ItemCraftedEvent event) {
        try {
            Player player = event.getPlayer();
            ItemStack itemStack = event.getCrafting();
            Vec3 pos = player.m_20182_();
            double defaultCraftingXp = Config.forgeConfig.defaultCraftingXp.get();
            double durabilityMultiplier = 1.0;
            Map<String, Double> xpValue = XP.getXp(itemStack, JType.XP_VALUE_CRAFT);
            HashMap<String, Double> award = new HashMap<String, Double>();
            if (xpValue.size() == 0) {
                if (itemStack.m_41720_() instanceof BlockItem) {
                    award.put("crafting", Double.valueOf(((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_().m_60800_(null, null)));
                } else {
                    award.put("crafting", defaultCraftingXp);
                }
            } else {
                XP.addMapsAnyDouble(award, xpValue);
            }
            if (itemStack.m_41763_()) {
                durabilityMultiplier = (double)(itemStack.m_41776_() - itemStack.m_41773_()) / (double)itemStack.m_41776_();
            }
            XP.multiplyMapAnyDouble(award, durabilityMultiplier);
            for (String awardSkillName : award.keySet()) {
                if (player instanceof ServerPlayer) {
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(player.m_183503_()), pos.m_7096_(), pos.m_7098_() + (double)player.m_20192_() + 0.523, pos.m_7094_(), 1.523, (Double)award.get(awardSkillName), awardSkillName);
                    XP.addWorldXpDrop(xpDrop, (ServerPlayer)player);
                }
                Skill.addXp(awardSkillName, player.m_142081_(), (double)((Double)award.get(awardSkillName)), "crafting", false, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("PMMO error while crafting", (Throwable)e);
        }
    }
}

