/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class DeathHandler {
    public static void handleDeath(LivingDeathEvent event) {
        LivingEntity target = event.getEntityLiving();
        Entity source = event.getSource().m_7639_();
        double deathPenaltyMultiplier = Config.forgeConfig.deathPenaltyMultiplier.get();
        double passiveMobHunterXp = Config.forgeConfig.passiveMobHunterXp.get();
        double aggresiveMobSlayerXp = Config.forgeConfig.aggresiveMobSlayerXp.get();
        boolean deathLoosesLevels = Config.forgeConfig.deathLoosesLevels.get();
        if (target instanceof ServerPlayer && !(target instanceof FakePlayer)) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (!player.f_19853_.m_5776_()) {
                Map<String, Double> xpMap = Config.getXpMap((Player)player);
                Map<String, Double> prefsMap = Config.getPreferencesMap((Player)player);
                double totalLost = 0.0;
                boolean wipeAllSkills = Config.forgeConfig.wipeAllSkillsUponDeathPermanently.get();
                if (prefsMap.containsKey("wipeAllSkillsUponDeathPermanently") && prefsMap.get("wipeAllSkillsUponDeathPermanently") != 0.0) {
                    wipeAllSkills = true;
                }
                if (wipeAllSkills) {
                    for (Map.Entry<String, Double> entry : new HashMap<String, Double>(xpMap).entrySet()) {
                        totalLost += entry.getValue().doubleValue();
                        xpMap.remove(entry.getKey());
                    }
                } else {
                    for (Map.Entry<String, Double> entry : new HashMap<String, Double>(xpMap).entrySet()) {
                        double lostXp;
                        double startXp = entry.getValue();
                        double floorXp = XP.xpAtLevelDecimal(Math.floor(XP.levelAtXpDecimal(startXp)));
                        double diffXp = startXp - floorXp;
                        if (deathLoosesLevels) {
                            double requiredLevel = XP.levelAtXpDecimal(startXp) * deathPenaltyMultiplier;
                            lostXp = startXp - XP.xpAtLevelDecimal(requiredLevel);
                        } else {
                            lostXp = diffXp * deathPenaltyMultiplier;
                        }
                        double finalXp = startXp - lostXp;
                        totalLost += lostXp;
                        if (finalXp > 0.0) {
                            xpMap.put(entry.getKey(), finalXp);
                            continue;
                        }
                        xpMap.remove(entry.getKey());
                    }
                }
                if (totalLost > 0.0) {
                    player.m_5661_((Component)new TranslatableComponent("pmmo.lostXp", new Object[]{DP.dprefix(totalLost)}).m_6270_(XP.textStyle.get("red")), false);
                }
                XP.syncPlayer((Player)player);
            }
        } else if (source instanceof ServerPlayer && !(source instanceof FakePlayer)) {
            ServerPlayer player = (ServerPlayer)source;
            Collection<Player> nearbyPlayers = XP.getNearbyPlayers((Entity)target);
            double scaleValue = 0.0;
            for (Player thePlayer : nearbyPlayers) {
                scaleValue += (double)Math.max(1.0f, XP.getPowerLevel(thePlayer.m_142081_()));
            }
            scaleValue = Math.max(1.0, Math.min(10.0, scaleValue * 0.2));
            scaleValue *= 0.2;
            boolean registeredNBTdata = TooltipSupplier.tooltipExists(target.m_6095_().getRegistryName(), JType.XP_VALUE_KILL);
            if (registeredNBTdata || JsonConfig.data.get((Object)JType.XP_VALUE_KILL).containsKey(target.m_20078_())) {
                Map<String, Double> killXp = registeredNBTdata ? XP.getXp((Entity)target, JType.XP_VALUE_KILL) : XP.getXpBypass(target.m_6095_().getRegistryName(), JType.XP_VALUE_KILL);
                for (Map.Entry<String, Double> entry : killXp.entrySet()) {
                    XP.awardXp(player, entry.getKey(), player.m_21205_().m_41786_().toString(), entry.getValue() * scaleValue, false, false, false);
                }
            } else if (target instanceof Animal) {
                XP.awardXp(player, Skill.HUNTER.toString(), player.m_21205_().m_41786_().toString(), passiveMobHunterXp * scaleValue, false, false, false);
            } else if (target instanceof Mob) {
                XP.awardXp(player, Skill.SLAYER.toString(), player.m_21205_().m_41786_().toString(), aggresiveMobSlayerXp * scaleValue, false, false, false);
            }
            if (JsonConfig.data.get((Object)JType.MOB_RARE_DROP).containsKey(target.m_20078_())) {
                Map<String, Double> dropTable = JsonConfig.data.get((Object)JType.MOB_RARE_DROP).get(target.m_20078_());
                for (Map.Entry<String, Double> entry : dropTable.entrySet()) {
                    double chance = entry.getValue();
                    if (Math.floor(Math.random() * (chance /= scaleValue)) != 0.0) continue;
                    ItemStack itemStack = new ItemStack((ItemLike)XP.getItem(entry.getKey()));
                    XP.dropItemStack(itemStack, player.f_19853_, target.m_20182_());
                    player.m_5661_((Component)new TranslatableComponent("pmmo.rareDrop", new Object[]{new TranslatableComponent(itemStack.m_41778_())}).m_6270_(XP.textStyle.get("green")), false);
                    player.m_5661_((Component)new TranslatableComponent("pmmo.rareDrop", new Object[]{new TranslatableComponent(itemStack.m_41778_())}).m_6270_(XP.textStyle.get("green")), true);
                }
            }
        }
    }
}

