/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.AnvilRepairHandler;
import harmonised.pmmo.events.BlockBrokenHandler;
import harmonised.pmmo.events.BlockPlacedHandler;
import harmonised.pmmo.events.BreakSpeedHandler;
import harmonised.pmmo.events.BreedHandler;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.events.CraftedHandler;
import harmonised.pmmo.events.DamageHandler;
import harmonised.pmmo.events.DeathHandler;
import harmonised.pmmo.events.FishedHandler;
import harmonised.pmmo.events.GrowHandler;
import harmonised.pmmo.events.JumpHandler;
import harmonised.pmmo.events.PistonEventHandler;
import harmonised.pmmo.events.PlayerConnectedHandler;
import harmonised.pmmo.events.PlayerDisconnectedHandler;
import harmonised.pmmo.events.PlayerInteractionHandler;
import harmonised.pmmo.events.PlayerRespawnHandler;
import harmonised.pmmo.events.PlayerTickHandler;
import harmonised.pmmo.events.ServerStoppingHandler;
import harmonised.pmmo.events.ShieldBlockHandler;
import harmonised.pmmo.events.SleepHandler;
import harmonised.pmmo.events.SpawnHandler;
import harmonised.pmmo.events.TameHandler;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.util.XP;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pmmo")
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void blockBroken(BlockEvent.BreakEvent event) {
        BlockBrokenHandler.handleBroken(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void blockPlaced(BlockEvent.EntityMultiPlaceEvent event) {
        if (event.getEntity() != null && BlockPlacedHandler.handlePlaced(event.getEntity(), event.getPlacedBlock(), (Level)event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void blockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() != null && BlockPlacedHandler.handlePlaced(event.getEntity(), event.getPlacedBlock(), (Level)event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void livingHurt(LivingHurtEvent event) {
        DamageHandler.handleDamage(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void livingDeath(LivingDeathEvent event) {
        DeathHandler.handleDeath(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerTickHandler.handlePlayerTick(event);
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerRespawnHandler.handlePlayerRespawn(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void livingJump(LivingEvent.LivingJumpEvent event) {
        if (event.isCanceled()) {
            return;
        }
        JumpHandler.handleJump(event);
    }

    @SubscribeEvent
    public static void PlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerConnectedHandler.handlePlayerConnected(event);
    }

    @SubscribeEvent
    public static void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        PlayerDisconnectedHandler.handlerPlayerDisconnected(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        AnvilRepairHandler.handleAnvilRepair(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemFished(ItemFishedEvent event) {
        FishedHandler.handleFished(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemCrafted(PlayerEvent.ItemCraftedEvent event) {
        CraftedHandler.handleCrafted(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        BreakSpeedHandler.handleBreakSpeed(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerInteract(PlayerInteractEvent event) {
        PlayerInteractionHandler.handlePlayerInteract(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void livingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        SpawnHandler.handleSpawn(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void babySpawn(BabyEntitySpawnEvent event) {
        BreedHandler.handleBreedEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void animalTaming(AnimalTameEvent event) {
        TameHandler.handleAnimalTaming(event);
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        WorldTickHandler.handleWorldTick(event);
    }

    @SubscribeEvent
    public static void serverStopping(ServerStoppingEvent event) {
        ServerStoppingHandler.handleServerStop(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void sleepDone(SleepFinishedTimeEvent event) {
        SleepHandler.handleSleepFinished(event);
    }

    @SubscribeEvent
    public static void chunkDataLoad(ChunkDataEvent.Load event) {
        ChunkDataHandler.handleChunkDataLoad(event);
    }

    @SubscribeEvent
    public static void chunkDataSave(ChunkDataEvent.Save event) {
        ChunkDataHandler.handleChunkDataSave(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void pistonPush(PistonEvent event) {
        PistonEventHandler.handlePistonPush(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void saplingGrow(SaplingGrowTreeEvent event) {
        GrowHandler.handleSaplingGrow(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void cropGrow(BlockEvent.CropGrowEvent.Post event) {
        GrowHandler.handleCropGrow(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void shieldBlock(ShieldBlockEvent event) {
        ShieldBlockHandler.handleBlock(event);
    }

    @SubscribeEvent
    public static void travelDimension(EntityTravelToDimensionEvent event) {
        ResourceLocation destination;
        Map<String, Double> reqMap;
        ServerPlayer player;
        if (event.getEntity() instanceof ServerPlayer && !XP.checkReq((Player)(player = (ServerPlayer)event.getEntity()), reqMap = APIUtils.getXp(destination = event.getDimension().m_135782_(), JType.REQ_DIMENSION_TRAVEL))) {
            event.setCanceled(true);
            player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToTravelToDimension", new Object[]{new TranslatableComponent(event.getDimension().m_135782_().toString())}).m_6270_(XP.textStyle.get("red")), true);
            player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToTravelToDimension", new Object[]{new TranslatableComponent(event.getDimension().m_135782_().toString())}).m_6270_(XP.textStyle.get("red")), false);
            XP.sendPlayerSkillList((Player)player, reqMap);
        }
    }
}

