/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.config.JType;
import harmonised.pmmo.events.ChunkDataHandler;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FurnaceHandler {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void handleSmelted(ItemStack input, ItemStack output, Level world, BlockPos pos, int type) {
        try {
            Object source;
            JType xpType;
            JType infoType;
            switch (type) {
                case 0: {
                    infoType = JType.INFO_SMELT;
                    xpType = JType.XP_VALUE_SMELT;
                    source = "Smelting";
                    break;
                }
                case 1: {
                    infoType = JType.INFO_COOK;
                    xpType = JType.XP_VALUE_COOK;
                    source = "Cooking";
                    break;
                }
                default: {
                    LOGGER.error("Project MMO handleSmelted WRONG TYPE");
                    return;
                }
            }
            source = (String)source + " " + input.m_41720_().getRegistryName();
            source = (String)source + " [" + XP.getDimResLoc(world).toString() + "|x" + pos.m_123341_() + "|y" + pos.m_123342_() + "|z" + pos.m_123343_() + "]";
            UUID uuid = ChunkDataHandler.checkPos(world, pos);
            if (uuid != null) {
                double extraChance = XP.getExtraChance(uuid, input.m_41720_().getRegistryName(), infoType, false) / 100.0;
                int guaranteedDrop = (int)extraChance;
                int extraDrop = XP.rollChance(extraChance % 1.0) ? 1 : 0;
                int totalExtraDrops = guaranteedDrop + extraDrop;
                output.m_41769_(totalExtraDrops);
                Map<String, Double> award = XP.multiplyMapAnyDouble(XP.getXp(input, xpType), 1 + totalExtraDrops);
                for (String awardSkillName : award.keySet()) {
                    WorldXpDrop xpDrop = WorldXpDrop.fromXYZ(XP.getDimResLoc(world), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.523, (double)pos.m_123343_() + 0.5, 0.4, award.get(awardSkillName), awardSkillName);
                    xpDrop.setDecaySpeed(0.25);
                    XP.addWorldXpDrop(xpDrop, uuid);
                    Skill.addXp(awardSkillName, uuid, (double)award.get(awardSkillName), (String)source, false, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

