/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events;

import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.gui.GlossaryScreen;
import harmonised.pmmo.proxy.ClientHandler;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.Util;
import harmonised.pmmo.util.XP;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TooltipHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean tooltipOn = true;
    private static String lastKey = "";
    private static int salvageFromArrayPos = 0;
    private static int salvageFromArrayLength;
    private static int salvageToArrayPos;
    private static int salvageToArrayLength;
    private static int treasureFromArrayPos;
    private static int treasureFromArrayLength;
    private static int treasureToArrayPos;
    private static int treasureToArrayLength;
    private static long lastTime;
    private static Object[] salvageFromArray;
    private static Object[] salvageToArray;
    private static Object[] treasureFromArray;
    private static Object[] treasureToArray;

    public static void handleTooltip(ItemTooltipEvent event) {
        block100: {
            try {
                String key;
                Map salvageToItemMap;
                int level;
                double dValue;
                BlockState state;
                if (!tooltipOn) {
                    return;
                }
                Player player = event.getPlayer();
                if (player == null) break block100;
                ItemStack itemStack = event.getItemStack();
                Item item = itemStack.m_41720_();
                List tooltip = event.getToolTip();
                if (item.getRegistryName() == null) {
                    return;
                }
                String regKey = item.getRegistryName().toString();
                BlockState blockState = state = item instanceof BlockItem ? ((BlockItem)item).m_40614_().m_49966_() : null;
                if (ClientHandler.OPEN_MENU.m_90857_()) {
                    GlossaryScreen.setButtonsToKey(regKey);
                    Minecraft.m_91087_().m_91152_((Screen)new GlossaryScreen(Minecraft.m_91087_().f_91074_.m_142081_(), (Component)new TranslatableComponent("pmmo.glossary"), false));
                    return;
                }
                Map<String, Double> craftReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_CRAFT, itemStack);
                Map<String, Double> wearReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_WEAR, itemStack);
                Map<String, Double> toolReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_TOOL, itemStack);
                Map<String, Double> weaponReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_WEAPON, itemStack);
                Map<String, Double> useReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_USE, itemStack);
                Map<String, Double> useEnchantmentReq = XP.getEnchantsUseReq(itemStack);
                Map<String, Double> placeReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_PLACE, itemStack);
                Map<String, Double> breakReq = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.REQ_BREAK, itemStack);
                Map xpValueGeneral = ((Map)JsonConfig.data.getOrDefault((Object)JType.XP_VALUE_GENERAL, new HashMap())).getOrDefault(regKey, new HashMap());
                Map<String, Double> xpValueBreaking = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.XP_VALUE_BREAK, itemStack);
                Map<String, Double> xpValueCrafting = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.XP_VALUE_CRAFT, itemStack);
                Map<String, Double> xpValueSmelting = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.XP_VALUE_SMELT, itemStack);
                Map<String, Double> xpValueCooking = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.XP_VALUE_COOK, itemStack);
                Map<String, Double> xpValueBrewing = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.XP_VALUE_BREW, itemStack);
                Map xpValueGrowing = ((Map)JsonConfig.data.getOrDefault((Object)JType.XP_VALUE_GROW, new HashMap())).getOrDefault(regKey, new HashMap());
                Map<String, Double> xpValuePlacing = TooltipSupplier.getTooltipData(new ResourceLocation(regKey), JType.XP_VALUE_PLACE, itemStack);
                Map salvageInfo = ((Map)JsonConfig.data2.getOrDefault((Object)JType.SALVAGE, new HashMap())).getOrDefault(regKey, new HashMap());
                Map salvageFrom = ((Map)JsonConfig.data2.getOrDefault((Object)JType.SALVAGE_FROM, new HashMap())).getOrDefault(regKey, new HashMap());
                Map treasureInfo = ((Map)JsonConfig.data2.getOrDefault((Object)JType.TREASURE, new HashMap())).getOrDefault(regKey, new HashMap());
                Map treasureFromInfo = ((Map)JsonConfig.data2.getOrDefault((Object)JType.TREASURE_FROM, new HashMap())).getOrDefault(regKey, new HashMap());
                Map<String, Double> heldItemXpBoost = XP.getStackXpBoosts(itemStack, true);
                Map<String, Double> wornItemXpBoost = XP.getStackXpBoosts(itemStack, false);
                if (Config.getConfig("autoGenerateValuesEnabled") != 0.0) {
                    double dynReq;
                    if (Config.getConfig("autoGenerateWearReqDynamicallyEnabled") != 0.0) {
                        if (wearReq == null) {
                            wearReq = new HashMap<String, Double>();
                        }
                        String wearReqSkill = Config.getConfig("autoGenerateWearReqAsCombat") != 0.0 ? Skill.COMBAT.toString() : Skill.ENDURANCE.toString();
                        dynReq = AutoValues.getWearReqFromStack(itemStack) + XP.getJsonMap(regKey, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWear", 0.0);
                        if (dynReq > 0.0 && !wearReq.containsKey(wearReqSkill) && Config.getConfig("wearReqEnabled") != 0.0 && wearReq.getOrDefault(wearReqSkill, 0.0) < dynReq) {
                            wearReq.put(wearReqSkill, dynReq);
                        }
                    }
                    Iterator<String> itemSpecificSkill = AutoValues.getItemSpecificSkillOrDefault(regKey, Skill.COMBAT.toString());
                    if (Config.getConfig("weaponReqEnabled") != 0.0 && Config.getConfig("autoGenerateWeaponReqDynamicallyEnabled") != 0.0) {
                        if (weaponReq == null) {
                            weaponReq = new HashMap<String, Double>();
                        }
                        if ((dynReq = AutoValues.getWeaponReqFromStack(itemStack) + XP.getJsonMap(regKey, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetWeapon", 0.0)) > 0.0 && !weaponReq.containsKey(itemSpecificSkill)) {
                            weaponReq.put((String)((Object)itemSpecificSkill), dynReq);
                        }
                    }
                    if (Config.getConfig("toolReqEnabled") != 0.0 && Config.getConfig("autoGenerateToolReqDynamicallyEnabled") != 0.0) {
                        if (toolReq == null) {
                            toolReq = new HashMap<String, Double>();
                        }
                        Map<String, Double> dynToolReqMap = AutoValues.getToolReqFromStack(itemStack);
                        for (Map.Entry<String, Double> entry : dynToolReqMap.entrySet()) {
                            double dynReq2 = entry.getValue() + XP.getJsonMap(regKey, JType.ITEM_SPECIFIC).getOrDefault("autoValueOffsetTool", 0.0);
                            if (!(dynReq2 > 0.0) || toolReq.containsKey(entry.getKey())) continue;
                            toolReq.put(entry.getKey(), dynReq2);
                        }
                    }
                }
                if (xpValueGeneral != null && xpValueGeneral.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValue"));
                    for (String key2 : xpValueGeneral.keySet()) {
                        dValue = (Double)xpValueGeneral.get(key2);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key2).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key2)));
                    }
                }
                if (xpValueBreaking != null && xpValueBreaking.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValueBreak"));
                    for (String key3 : xpValueBreaking.keySet()) {
                        dValue = xpValueBreaking.get(key3);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key3).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key3)));
                    }
                }
                if (xpValueCrafting != null && xpValueCrafting.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValueCraft"));
                    for (String key4 : xpValueCrafting.keySet()) {
                        dValue = xpValueCrafting.get(key4);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key4).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key4)));
                    }
                }
                if (xpValueSmelting != null && xpValueSmelting.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValueSmelt"));
                    for (String key5 : xpValueSmelting.keySet()) {
                        dValue = xpValueSmelting.get(key5);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key5).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key5)));
                    }
                }
                if (xpValueCooking != null && xpValueCooking.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValueCook"));
                    for (String key6 : xpValueCooking.keySet()) {
                        dValue = xpValueCooking.get(key6);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key6).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key6)));
                    }
                }
                if (xpValueBrewing != null && xpValueBrewing.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValueBrew"));
                    for (String key7 : xpValueBrewing.keySet()) {
                        dValue = xpValueBrewing.get(key7);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key7).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key7)));
                    }
                }
                if (xpValueGrowing != null && xpValueGrowing.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValueGrow"));
                    for (String key8 : xpValueGrowing.keySet()) {
                        dValue = (Double)xpValueGrowing.get(key8);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key8).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key8)));
                    }
                }
                if (xpValuePlacing != null && xpValuePlacing.size() > 0) {
                    tooltip.add(new TranslatableComponent("pmmo.xpValuePlace"));
                    for (String key9 : xpValuePlacing.keySet()) {
                        dValue = xpValuePlacing.get(key9);
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key9).getString(), DP.dp(dValue)}).m_6270_(Skill.getSkillStyle(key9)));
                    }
                }
                if (craftReq != null && craftReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.toCraft", craftReq, event);
                }
                if (wearReq != null && wearReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.toWear", wearReq, event);
                }
                if (heldItemXpBoost != null && heldItemXpBoost.size() > 0) {
                    heldItemXpBoost = new HashMap<String, Double>(heldItemXpBoost);
                    TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostHeld", heldItemXpBoost, event);
                }
                if (wornItemXpBoost != null && wornItemXpBoost.size() > 0) {
                    wornItemXpBoost = new HashMap<String, Double>(wornItemXpBoost);
                    TooltipHandler.addTooltipTextSkillPercentage("pmmo.itemXpBoostWorn", wornItemXpBoost, event);
                }
                if (toolReq != null && toolReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.tool", toolReq, event);
                }
                if (weaponReq != null && weaponReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.weapon", weaponReq, event);
                }
                if (useReq != null && useReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.use", useReq, event);
                }
                if (useEnchantmentReq.size() > 0) {
                    TooltipHandler.addTooltipTextSkill("pmmo.enchantReq", useEnchantmentReq, event);
                }
                if (placeReq != null && placeReq.size() > 0) {
                    if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                        TooltipHandler.addTooltipTextSkill("pmmo.plant", placeReq, event);
                    } else {
                        TooltipHandler.addTooltipTextSkill("pmmo.place", placeReq, event);
                    }
                }
                if (breakReq != null && breakReq.size() > 0) {
                    if (state != null && XP.getHarvestTool(state).equals("axe")) {
                        TooltipHandler.addTooltipTextSkill("pmmo.chop", breakReq, event);
                    } else if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(item.getRegistryName().toString()) || item instanceof IPlantable) {
                        TooltipHandler.addTooltipTextSkill("pmmo.harvest", breakReq, event);
                    } else {
                        TooltipHandler.addTooltipTextSkill("pmmo.break", breakReq, event);
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_ORE).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_ORE).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.m_142081_(), item.getRegistryName(), JType.INFO_ORE, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslatableComponent("pmmo.oreExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).m_6270_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslatableComponent("pmmo.oreExtraDrop", new Object[]{0}).m_6270_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_LOG).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_LOG).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.m_142081_(), item.getRegistryName(), JType.INFO_LOG, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslatableComponent("pmmo.logExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).m_6270_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslatableComponent("pmmo.logExtraDrop", new Object[]{0}).m_6270_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_PLANT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_PLANT).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.m_142081_(), item.getRegistryName(), JType.INFO_PLANT, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslatableComponent("pmmo.plantExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).m_6270_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslatableComponent("pmmo.plantExtraDrop", new Object[]{0}).m_6270_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_SMELT).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_SMELT).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.m_142081_(), item.getRegistryName(), JType.INFO_SMELT, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslatableComponent("pmmo.smeltExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).m_6270_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslatableComponent("pmmo.smeltExtraDrop", new Object[]{0}).m_6270_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_COOK).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_COOK).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.m_142081_(), item.getRegistryName(), JType.INFO_COOK, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslatableComponent("pmmo.cookExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).m_6270_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslatableComponent("pmmo.cookExtraDrop", new Object[]{0}).m_6270_(XP.textStyle.get("red")));
                    }
                }
                if (JsonConfig.data.get((Object)JType.INFO_BREW).containsKey(regKey) && JsonConfig.data.get((Object)JType.INFO_BREW).get(regKey).containsKey("extraChance")) {
                    dValue = XP.getExtraChance(player.m_142081_(), item.getRegistryName(), JType.INFO_BREW, true);
                    if (dValue > 0.0) {
                        tooltip.add(new TranslatableComponent("pmmo.brewExtraDrop", new Object[]{DP.dp(dValue / 100.0)}).m_6270_(XP.textStyle.get("green")));
                    } else {
                        tooltip.add(new TranslatableComponent("pmmo.brewExtraDrop", new Object[]{0}).m_6270_(XP.textStyle.get("red")));
                    }
                }
                if (System.nanoTime() - lastTime > 900000000L) {
                    lastTime = System.nanoTime();
                    if (++salvageToArrayPos >= salvageToArrayLength) {
                        salvageToArrayPos = 0;
                    }
                    if (++salvageFromArrayPos >= salvageFromArrayLength) {
                        salvageFromArrayPos = 0;
                    }
                    if (++treasureToArrayPos >= treasureToArrayLength) {
                        treasureToArrayPos = 0;
                    }
                    if (++treasureFromArrayPos >= treasureFromArrayLength) {
                        treasureFromArrayPos = 0;
                    }
                }
                if (!lastKey.equals(regKey)) {
                    if (salvageInfo != null) {
                        salvageToArray = salvageInfo.keySet().toArray();
                        salvageToArrayLength = salvageToArray.length;
                        salvageToArrayPos = 0;
                    }
                    if (salvageFrom != null) {
                        salvageFromArray = salvageFrom.keySet().toArray();
                        salvageFromArrayLength = salvageFromArray.length;
                        salvageFromArrayPos = 0;
                    }
                    if (treasureInfo != null) {
                        treasureToArray = treasureInfo.keySet().toArray();
                        treasureToArrayLength = treasureToArray.length;
                        treasureToArrayPos = 0;
                    }
                    if (treasureFromInfo != null) {
                        treasureFromArray = treasureFromInfo.keySet().toArray();
                        treasureFromArrayLength = treasureFromArray.length;
                        treasureFromArrayPos = 0;
                    }
                    lastKey = regKey;
                }
                if (salvageInfo != null && salvageInfo.size() > 0) {
                    try {
                        if (salvageToArray.length > 0) {
                            double maxSalvageMaterialChance;
                            level = Skill.getLevel(Skill.SMITHING.toString(), player);
                            String key10 = (String)salvageToArray[salvageToArrayPos];
                            salvageToItemMap = (Map)salvageInfo.get(key10);
                            int reqLevel = (int)Math.floor((Double)salvageToItemMap.get("levelReq"));
                            int finalLevel = level - reqLevel;
                            double baseChance = (Double)salvageToItemMap.get("baseChance");
                            double xpPerItem = (Double)salvageToItemMap.get("xpPerItem");
                            double chancePerLevel = (Double)salvageToItemMap.get("chancePerLevel");
                            double chance = baseChance + chancePerLevel * (double)finalLevel;
                            if (chance > (maxSalvageMaterialChance = ((Double)salvageToItemMap.get("maxChance")).doubleValue())) {
                                chance = maxSalvageMaterialChance;
                            }
                            int salvageMax = (int)Math.floor((Double)salvageToItemMap.get("salvageMax"));
                            double durabilityPercent = 1.0 - (double)itemStack.m_41773_() / (double)itemStack.m_41776_();
                            if (Double.isNaN(durabilityPercent)) {
                                durabilityPercent = 1.0;
                            }
                            int potentialReturnAmount = (int)Math.floor((double)salvageMax * durabilityPercent);
                            Item salvageItem = XP.getItem(key10);
                            if (finalLevel < 0) {
                                tooltip.add(new TranslatableComponent("pmmo.cannotSalvageLackLevel", new Object[]{reqLevel}).m_6270_(XP.textStyle.get("red")));
                            } else {
                                tooltip.add(new TranslatableComponent("pmmo.salvagesIntoCountItem", new Object[]{potentialReturnAmount, new TranslatableComponent(salvageItem.m_5524_())}).m_6270_(XP.textStyle.get(potentialReturnAmount > 0 ? "green" : "red")));
                                tooltip.add(new TranslatableComponent("pmmo.xpEachChanceEach", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).m_6270_(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)e);
                    }
                }
                if (salvageFrom != null) {
                    try {
                        if (salvageFromArray.length > 0) {
                            tooltip.add(new TranslatableComponent("pmmo.canBeSalvagedFrom").m_6270_(XP.textStyle.get("green")));
                            level = Skill.getLevel(Skill.SMITHING.toString(), player);
                            key = (String)salvageFromArray[salvageFromArrayPos];
                            String displayName = new TranslatableComponent(XP.getItem(key).m_5524_()).getString();
                            Map salvageFromMap = (Map)salvageFrom.get(key);
                            tooltip.add(new TranslatableComponent("pmmo.valueFromValue", new Object[]{" " + (int)((Double)salvageFromMap.get("salvageMax")).doubleValue(), displayName}).m_6270_(XP.textStyle.get((Double)salvageFromMap.get("levelReq") > (double)level ? "red" : "green")));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Salvage Tooltip Error: " + e);
                    }
                }
                if (treasureInfo != null && treasureInfo.size() > 0) {
                    try {
                        if (treasureToArray.length > 0) {
                            level = Skill.getLevel(Skill.EXCAVATION.toString(), player);
                            String key11 = (String)treasureToArray[treasureToArrayPos];
                            salvageToItemMap = (Map)treasureInfo.get(key11);
                            double chance = Util.mapCapped(level, (Double)salvageToItemMap.get("startLevel"), (Double)salvageToItemMap.get("endLevel"), (Double)salvageToItemMap.get("startChance"), (Double)salvageToItemMap.get("endChance"));
                            double xpPerItem = (Double)salvageToItemMap.get("xpPerItem");
                            String itemName = new TranslatableComponent(XP.getItem(key11).m_5524_()).getString();
                            int minCount = (int)((Double)salvageToItemMap.get("minCount")).doubleValue();
                            int maxCount = (int)((Double)salvageToItemMap.get("maxCount")).doubleValue();
                            if (chance > 100.0) {
                                chance = 100.0;
                            }
                            if (chance <= 0.0) {
                                chance = 0.0;
                            }
                            tooltip.add(new TranslatableComponent("pmmo.containsCountItemTreasure", new Object[]{minCount == maxCount ? Integer.valueOf(minCount) : minCount + "-" + maxCount, itemName}).m_6270_(XP.textStyle.get("green")));
                            tooltip.add(new TranslatableComponent("pmmo.xpEachChance", new Object[]{" " + DP.dp(xpPerItem), DP.dp(chance)}).m_6270_(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Treasure Info Tooltip: " + e);
                    }
                }
                if (treasureFromInfo != null) {
                    try {
                        if (treasureFromArray.length > 0) {
                            tooltip.add(new TranslatableComponent("pmmo.treasureFrom").m_6270_(XP.textStyle.get("green")));
                            level = Skill.getLevel(Skill.EXCAVATION.toString(), player);
                            key = (String)treasureFromArray[treasureFromArrayPos];
                            String displayName = new TranslatableComponent(XP.getItem(key).m_5524_()).getString();
                            Map treasureFromMap = (Map)treasureFromInfo.get(key);
                            Map<String, Double> treasureToMap = JsonConfig.data2.get((Object)JType.TREASURE).get(key).get(regKey);
                            int minCount = (int)((Double)treasureFromMap.get("minCount")).doubleValue();
                            int maxCount = (int)((Double)treasureFromMap.get("maxCount")).doubleValue();
                            double chance = Util.mapCapped(level, treasureToMap.get("startLevel"), treasureToMap.get("endLevel"), treasureToMap.get("startChance"), treasureToMap.get("endChance"));
                            tooltip.add(new TranslatableComponent("pmmo.valueFromValue", new Object[]{" " + (Serializable)(minCount == maxCount ? Integer.valueOf(minCount) : minCount + "-" + maxCount), displayName}).m_6270_(XP.textStyle.get(chance > 0.0 ? "green" : "red")));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("TreasureFrom Tooltip Error: " + e);
                    }
                }
                if (event.getFlags().m_7050_()) {
                    float hardness;
                    for (ResourceLocation tagKey : item.getTags()) {
                        tooltip.add(new TextComponent("#" + tagKey.toString()).m_6270_(XP.getColorStyle(0x666666)));
                    }
                    if (state != null && (hardness = state.m_60800_(null, new BlockPos(0, 0, 0))) > 0.0f) {
                        tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo.hardness", new Object[]{DP.dp(Float.valueOf(hardness))}).getString()}));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addTooltipTextSkill(String tKey, Map<String, Double> theMap, ItemTooltipEvent event) {
        Player player = event.getPlayer();
        List tooltip = event.getToolTip();
        if (theMap.size() > 0) {
            tooltip.add(new TranslatableComponent(tKey).m_6270_(XP.textStyle.get(XP.checkReq(player, theMap) ? "green" : "red")));
            for (String key : theMap.keySet()) {
                double value = theMap.get(key);
                if (!(value > 1.0)) continue;
                double level = Skill.getLevel(key, player);
                tooltip.add(new TranslatableComponent("pmmo.levelDisplay", new Object[]{" " + new TranslatableComponent("pmmo." + key).getString(), DP.dpSoft(value)}).m_6270_(XP.textStyle.get(level < value ? "red" : "green")));
            }
        }
    }

    private static void addTooltipTextSkillPercentage(String tKey, Map<String, Double> theMap, ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (theMap.size() > 0) {
            tooltip.add(new TranslatableComponent(tKey).m_6270_(XP.textStyle.get("green")));
            for (String key : theMap.keySet()) {
                double value = theMap.get(key);
                if (value < 0.0) {
                    tooltip.add(new TranslatableComponent("pmmo.levelDisplayPercentage", new Object[]{" " + DP.dp(value), new TranslatableComponent("pmmo." + key).getString()}).m_6270_(XP.textStyle.get("red")));
                    continue;
                }
                tooltip.add(new TranslatableComponent("pmmo.levelDisplayPercentage", new Object[]{" +" + DP.dp(value), new TranslatableComponent("pmmo." + key).getString()}).m_6270_(Skill.getSkillStyle(key)));
            }
        }
    }

    static {
        salvageToArrayPos = 0;
        treasureFromArrayPos = 0;
        treasureToArrayPos = 0;
        lastTime = System.nanoTime();
    }
}

