/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WorldRenderHandler {
    private static long lastTime = System.nanoTime();
    private static final Font fr = Minecraft.m_91087_().f_91062_;
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
    private static final Map<ResourceLocation, List<WorldXpDrop>> xpDrops = new HashMap<ResourceLocation, List<WorldXpDrop>>();
    private static final Map<ResourceLocation, List<WorldText>> worldTexts = new HashMap<ResourceLocation, List<WorldText>>();
    private static long currTime;
    private static double d;

    @SubscribeEvent
    public void handleWorldRender(RenderLevelLastEvent event) {
        currTime = System.nanoTime();
        d = (double)(currTime - lastTime) / 1.0E9;
        WorldRenderHandler.renderWorldText(event);
        WorldRenderHandler.renderWorldXpDrops(event);
        if (XP.isPlayerSurvival((Player)WorldRenderHandler.mc.f_91074_)) {
            WorldRenderHandler.drawBoxHighlights(event);
        }
    }

    public static void drawBoxHighlights(RenderLevelLastEvent event) {
        PoseStack stack = event.getPoseStack();
        Vec3 cameraPos = WorldRenderHandler.mc.m_91290_().f_114358_.m_90583_();
        stack.m_85836_();
        stack.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110504_());
        stack.m_85849_();
        RenderSystem.m_69465_();
        buffer.m_109911_();
    }

    public static void drawBoxHighlight(PoseStack stack, VertexConsumer builder, BlockPos pos) {
        stack.m_85836_();
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        int red = 255;
        int green = 0;
        int blue = 255;
        int alpha = 255;
        block5: for (int i = 0; i < 12; ++i) {
            int mode = i / 4;
            int j = i % 4;
            float modulus = j % 2;
            float divide = j / 2;
            switch (mode) {
                case 0: {
                    builder.m_85982_(matrix4f, (float)pos.m_123341_() + modulus, (float)pos.m_123342_() + divide, (float)pos.m_123343_()).m_6122_(red, green, blue, alpha).m_5752_();
                    builder.m_85982_(matrix4f, (float)pos.m_123341_() + modulus, (float)pos.m_123342_() + divide, (float)(pos.m_123343_() + 1)).m_6122_(red, green, blue, alpha).m_5752_();
                    continue block5;
                }
                case 1: {
                    builder.m_85982_(matrix4f, (float)pos.m_123341_(), (float)pos.m_123342_() + modulus, (float)pos.m_123343_() + divide).m_6122_(red, green, blue, alpha).m_5752_();
                    builder.m_85982_(matrix4f, (float)(pos.m_123341_() + 1), (float)pos.m_123342_() + modulus, (float)pos.m_123343_() + divide).m_6122_(red, green, blue, alpha).m_5752_();
                    continue block5;
                }
                case 2: {
                    builder.m_85982_(matrix4f, (float)pos.m_123341_() + divide, (float)pos.m_123342_(), (float)pos.m_123343_() + modulus).m_6122_(red, green, blue, alpha).m_5752_();
                    builder.m_85982_(matrix4f, (float)pos.m_123341_() + divide, (float)(pos.m_123342_() + 1), (float)pos.m_123343_() + modulus).m_6122_(red, green, blue, alpha).m_5752_();
                }
            }
        }
        stack.m_85849_();
    }

    public static void drawText(PoseStack stack, Vec3 cameraPos, Vec3 textPos, String text, float scale, float rotation, int color) {
        stack.m_85836_();
        float textWidth = fr.m_92895_(text);
        float textOffset = -textWidth / 2.0f;
        stack.m_85837_(textPos.m_7096_() - cameraPos.m_7096_(), textPos.m_7098_() - cameraPos.m_7098_(), textPos.m_7094_() - cameraPos.m_7094_());
        stack.m_85845_(mc.m_91290_().m_114470_());
        stack.m_85845_(Vector3f.f_122227_.m_122240_(rotation));
        stack.m_85841_(-scale, -scale, scale);
        FormattedCharSequence reorderingProcessor = FormattedCharSequence.m_13714_((String)text, (Style)XP.getColorStyle(color));
        fr.m_92733_(reorderingProcessor, textOffset, 0.0f, color, true, stack.m_85850_().m_85861_(), (MultiBufferSource)buffer, false, color, 225);
        stack.m_85849_();
    }

    private static void renderWorldText(RenderLevelLastEvent event) {
        ClientLevel world = WorldRenderHandler.mc.f_91073_;
        if (world == null) {
            return;
        }
        ResourceLocation dimResLoc = XP.getDimResLoc((Level)world);
        if (!worldTexts.containsKey(dimResLoc)) {
            return;
        }
        List<WorldText> dimTexts = worldTexts.get(dimResLoc);
        PoseStack stack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Vec3 cameraPos = WorldRenderHandler.mc.f_91063_.m_109153_().m_90583_();
        stack.m_85836_();
        for (int i = dimTexts.size() - 1; i >= 0; --i) {
            WorldText worldText = dimTexts.get(i);
            if (worldText == null) continue;
            if (!worldText.tick(d * (1.0 + (double)i * 0.01))) {
                dimTexts.remove(i);
                continue;
            }
            WorldRenderHandler.drawText(stack, cameraPos, worldText.getPos(), worldText.getText(), (float)worldText.getSize(), worldText.getRotation(), worldText.getColor());
        }
        stack.m_85849_();
        buffer.m_109911_();
        lastTime = currTime;
    }

    private static void renderWorldXpDrops(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        ResourceLocation dimResLoc = XP.getDimResLoc((Level)world);
        if (!xpDrops.containsKey(dimResLoc)) {
            return;
        }
        List<WorldXpDrop> dimXpDrops = xpDrops.get(dimResLoc);
        PoseStack stack = event.getPoseStack();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        stack.m_85836_();
        for (int i = dimXpDrops.size() - 1; i >= 0; --i) {
            WorldXpDrop xpDrop = dimXpDrops.get(i);
            if (xpDrop == null) continue;
            if (xpDrop.xp <= 0.0f) {
                dimXpDrops.remove(i);
                continue;
            }
            float scale = 0.02f * (xpDrop.xp / xpDrop.getStartXp()) * xpDrop.getSize() * WorldText.worldXpDropsSizeMultiplier;
            int color = xpDrop.getColor();
            String text = "+" + DP.dpSoft(xpDrop.xp);
            if (WorldText.worldXpDropsShowSkill) {
                text = text + " " + new TranslatableComponent(xpDrop.getSkill()).getString();
            }
            WorldRenderHandler.drawText(stack, cameraPos, xpDrop.getPos(), text, scale, xpDrop.getRotation(), color);
            xpDrop.xp = (float)((double)xpDrop.xp - Math.max(0.01523, (double)(xpDrop.xp * xpDrop.getDecaySpeed()) * (1.0 + (double)i * 0.01)) * (double)WorldText.worldXpDropsDecaySpeedMultiplier * d);
        }
        stack.m_85849_();
        buffer.m_109911_();
        lastTime = currTime;
    }

    public static void addWorldXpDropOffline(WorldXpDrop xpDrop) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && Config.getPreferencesMap((Player)player).getOrDefault("worldXpDropsEnabled", 1.0) != 0.0) {
            ResourceLocation dimResLoc = xpDrop.getWorldResLoc();
            if (!xpDrops.containsKey(dimResLoc)) {
                xpDrops.put(dimResLoc, new ArrayList());
                lastTime = System.nanoTime();
            }
            xpDrops.get(dimResLoc).add(xpDrop);
        }
    }

    public static void addWorldTextOffline(WorldText worldText) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ResourceLocation dimResLoc = worldText.getWorldResLoc();
        if (!worldTexts.containsKey(dimResLoc)) {
            worldTexts.put(dimResLoc, new ArrayList());
            lastTime = System.nanoTime();
        }
        worldTexts.get(dimResLoc).add(worldText);
    }
}

