/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.DP;
import harmonised.pmmo.util.XP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageLevelUp {
    public static final Logger LOGGER = LogManager.getLogger();
    private int level;
    private String skill;

    public MessageLevelUp(String skill, int level) {
        this.skill = skill;
        this.level = level;
    }

    public MessageLevelUp() {
    }

    public static MessageLevelUp decode(FriendlyByteBuf buf) {
        MessageLevelUp packet = new MessageLevelUp();
        packet.skill = buf.m_130136_(64);
        packet.level = buf.readInt();
        return packet;
    }

    public static void encode(MessageLevelUp packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.skill);
        buf.writeInt(packet.level);
    }

    public static void handlePacket(MessageLevelUp packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                String skill = packet.skill.toLowerCase();
                int realLevel = Skill.getLevel(skill, (Player)player);
                if (packet.level <= realLevel) {
                    Map<String, Double> prefsMap = Config.getPreferencesMap((Player)player);
                    Vec3 playerPos = player.m_20182_();
                    WorldText explosionText = WorldText.fromVector(XP.getDimResLoc((Level)player.m_183503_()), player.m_20182_());
                    explosionText.setColor(Skill.getSkillColor(skill));
                    explosionText.setText(player.m_5446_().getString() + " " + packet.level + " " + skill + " level up!");
                    explosionText.setMaxOffset(1.0f);
                    explosionText.setStartSize(4.0f);
                    explosionText.setEndSize(0.0f);
                    explosionText.setSecondsLifespan(15.23f);
                    if (Config.forgeConfig.levelUpFirework.get().booleanValue() && (!prefsMap.containsKey("spawnFireworksCausedByMe") || prefsMap.get("spawnFireworksCausedByMe") != 0.0)) {
                        XP.spawnRocket(player.f_19853_, player.m_20182_(), skill, explosionText);
                    }
                    LOGGER.info(player.m_5446_().getString() + " has reached level " + packet.level + " in " + skill + "! [" + XP.getDimResLoc(player.f_19853_).toString() + "|x:" + DP.dp(playerPos.m_7096_()) + "|y:" + DP.dp(playerPos.m_7098_()) + "|z:" + DP.dp(playerPos.m_7094_()) + "]");
                    if (Config.forgeConfig.broadcastMilestone.get().booleanValue()) {
                        boolean totalLevelMilestone;
                        HashMap<String, Double> skillsMap = new HashMap<String, Double>(PmmoSavedData.get().getXpMap(player.m_142081_()));
                        skillsMap.put(skill, XP.xpAtLevel(packet.level));
                        int totalLevel = XP.getTotalLevelFromMap(skillsMap);
                        boolean levelUpMilestone = packet.level % Config.forgeConfig.levelsPerMilestone.get() == 0;
                        boolean bl = totalLevelMilestone = totalLevel % Config.forgeConfig.levelsPerTotalLevelMilestone.get() == 0;
                        if (levelUpMilestone || totalLevelMilestone) {
                            ArrayList players = new ArrayList(player.f_8924_.m_6846_().m_11314_());
                            for (ServerPlayer otherPlayer : players) {
                                if (otherPlayer.m_142081_() == player.m_142081_()) continue;
                                Map<String, Double> otherprefsMap = Config.getPreferencesMap((Player)otherPlayer);
                                if (levelUpMilestone) {
                                    otherPlayer.m_5661_((Component)new TranslatableComponent("pmmo.milestoneLevelUp", new Object[]{player.m_5446_(), packet.level, new TranslatableComponent("pmmo." + skill)}).m_6270_(Skill.getSkillStyle(skill)), false);
                                    if (Config.forgeConfig.milestoneLevelUpFirework.get().booleanValue() && (!otherprefsMap.containsKey("spawnFireworksCausedByOthers") || otherprefsMap.get("spawnFireworksCausedByOthers") != 0.0)) {
                                        XP.spawnRocket(otherPlayer.f_19853_, otherPlayer.m_20182_(), skill, explosionText);
                                    }
                                }
                                if (!totalLevelMilestone) continue;
                                otherPlayer.m_5661_((Component)new TranslatableComponent("pmmo.milestoneTotalLevel", new Object[]{player.m_5446_(), totalLevel}).m_6270_(XP.getColorStyle(65280)), false);
                            }
                        }
                    }
                } else {
                    NetworkHandler.sendToPlayer(new MessageXp(Skill.getXp(skill, (Player)player), skill, 0.0, true), player);
                }
            }
            catch (Exception e) {
                LOGGER.debug((Object)e);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

