/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.network;

import harmonised.pmmo.config.JsonConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    private static JsonStructure data;

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readJsonFromUrl(String url, Class<T> type) throws IOException {
        try (InputStream is = new URL(url).openStream();){
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = WebHandler.readAll(rd);
            Object object = JsonConfig.gson.fromJson(jsonText, type);
            return (T)object;
        }
    }

    public static void updateInfo() {
        try {
            JsonStructure newData;
            data = newData = WebHandler.readJsonFromUrl("https://raw.githubusercontent.com/Harmonised7/db/master/pmmo.json", JsonStructure.class);
        }
        catch (IOException e) {
            LOGGER.warn("Could not connect to PMMO data server");
        }
    }

    public static JsonStructure getWebData() {
        return data;
    }

    public static String getLatestVersion() {
        try {
            return (String)WebHandler.getWebData().objs.get("latestVersion1.16");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getLatestMessage() {
        try {
            return (String)WebHandler.getWebData().objs.get("latestMessage1.16");
        }
        catch (Exception e) {
            return null;
        }
    }

    public class JsonStructure {
        public final Map<String, Object> objs = new HashMap<String, Object>();
    }
}

