/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.perks;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.function.TriFunction;

public class AttributePerks {
    private static final String MAX_BOOST = "max_boost";
    private static final String PER_LEVEL = "per_level";
    private static final CompoundTag NONE = new CompoundTag();
    private static final UUID speedModifierID = UUID.fromString("d6103cbc-b90b-4c4b-b3c0-92701fb357b3");
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> SPEED = (player, nbt, level) -> {
        double maxSpeedBoost = nbt.m_128441_(MAX_BOOST) ? nbt.m_128459_(MAX_BOOST) : 1.0;
        double boostPerLevel = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 0.5;
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        double speedBoost = player.m_21051_(Attributes.f_22279_).m_22115_() * Math.max(0.0, Math.min(maxSpeedBoost, Math.min(maxSpeedBoost, (double)level.intValue() * boostPerLevel / 100.0)));
        if (speedBoost > 0.0 && (speedAttribute.m_22111_(speedModifierID) == null || speedAttribute.m_22111_(speedModifierID).m_22218_() != speedBoost)) {
            AttributeModifier speedModifier = new AttributeModifier(speedModifierID, "Speed bonus thanks to Agility Level", speedBoost, AttributeModifier.Operation.ADDITION);
            speedAttribute.m_22120_(speedModifierID);
            speedAttribute.m_22125_(speedModifier);
        }
        return NONE;
    };
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> SPEED_TERM = (p, nbt, l) -> {
        AttributeInstance speedAttribute = p.m_21051_(Attributes.f_22279_);
        speedAttribute.m_22120_(speedModifierID);
        return NONE;
    };
    private static final UUID damageModifierID = UUID.fromString("992b11f1-7b3f-48d9-8ebd-1acfc3257b17");
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> DAMAGE = (player, nbt, level) -> {
        double maxDamage = nbt.m_128441_(MAX_BOOST) ? nbt.m_128459_(MAX_BOOST) : 1.0;
        double perLevel = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 0.05;
        AttributeInstance damageAttribute = player.m_21051_(Attributes.f_22281_);
        double damageBoost = Math.min(maxDamage, (double)level.intValue() * perLevel);
        AttributeModifier damageModifier = new AttributeModifier(damageModifierID, "Damage Boost thanks to Combat Level", damageBoost, AttributeModifier.Operation.MULTIPLY_BASE);
        damageAttribute.m_22120_(damageModifierID);
        damageAttribute.m_22125_(damageModifier);
        return NONE;
    };
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> DAMAGE_TERM = (player, nbt, level) -> {
        AttributeInstance damageAttribute = player.m_21051_(Attributes.f_22281_);
        damageAttribute.m_22120_(damageModifierID);
        return NONE;
    };
    private static final UUID reachModifierID = UUID.fromString("b20d3436-0d39-4868-96ab-d0a4856e68c6");
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> REACH = (player, nbt, level) -> {
        double perLevel = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 0.1;
        double maxReach = nbt.m_128441_(MAX_BOOST) ? nbt.m_128459_(MAX_BOOST) : 10.0;
        double reach = -0.91 + (double)level.intValue() * perLevel;
        reach = Math.min(maxReach, reach);
        AttributeInstance reachAttribute = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttribute.m_22111_(reachModifierID) == null || reachAttribute.m_22111_(reachModifierID).m_22218_() != reach) {
            AttributeModifier reachModifier = new AttributeModifier(reachModifierID, "Reach bonus thanks to Build Level", reach, AttributeModifier.Operation.ADDITION);
            reachAttribute.m_22120_(reachModifierID);
            reachAttribute.m_22125_(reachModifier);
        }
        return NONE;
    };
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> REACH_TERM = (player, nbt, level) -> {
        AttributeInstance reachAttribute = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        reachAttribute.m_22120_(reachModifierID);
        return NONE;
    };
    private static final UUID hpModifierID = UUID.fromString("c95a6e8c-a1c3-4177-9118-1e2cf49b7fcb");
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> HEALTH = (player, nbt, level) -> {
        double perLevel = nbt.m_128441_(PER_LEVEL) ? nbt.m_128459_(PER_LEVEL) : 0.1;
        int maxHeart = nbt.m_128441_(MAX_BOOST) ? nbt.m_128451_(MAX_BOOST) : 10;
        int heartBoost = (int)(perLevel * (double)level.intValue());
        heartBoost = Math.min(maxHeart, heartBoost);
        AttributeInstance hpAttribute = player.m_21051_(Attributes.f_22276_);
        AttributeModifier hpModifier = new AttributeModifier(hpModifierID, "Max HP Bonus thanks to Endurance Level", (double)heartBoost, AttributeModifier.Operation.ADDITION);
        hpAttribute.m_22120_(hpModifierID);
        hpAttribute.m_22125_(hpModifier);
        return NONE;
    };
    public static final TriFunction<ServerPlayer, CompoundTag, Integer, CompoundTag> HEALTH_TERM = (player, nbt, level) -> {
        AttributeInstance hpAttribute = player.m_21051_(Attributes.f_22276_);
        hpAttribute.m_22120_(hpModifierID);
        return NONE;
    };
}

